/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;

public class Tempo
implements Serializable {
    private static final int SECOND_IN_MILLIS = 1000;
    private int value;
    private int percent;

    public Tempo(int n, int n2) {
        this.value = n;
        this.percent = n2;
    }

    public Tempo(int n) {
        this(n, 100);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int n) {
        this.percent = n;
    }

    public long getInMillis() {
        double d = 60.0 / (double)this.getValue() * 1000.0 * (double)this.getPercent() / 100.0;
        return (long)d;
    }

    public long getInUSQ() {
        double d = 60.0 / (double)this.getValue() * 1000.0 * 1000.0 * (double)this.getPercent() / 100.0;
        return (long)d;
    }

    public static Tempo fromUSQ(int n) {
        double d = 60000.0 / ((double)n / 1000.0);
        return new Tempo((int)d);
    }

    public Object clone() {
        return new Tempo(this.getValue(), this.getPercent());
    }
}

