/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongTrackManager {
    private SongManager songManager;

    public SongTrackManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public int countMeasures(SongTrack songTrack) {
        return songTrack.getMeasures().size();
    }

    public Measure getFirstMeasure(SongTrack songTrack) {
        Measure measure = null;
        for (int i = 0; i < songTrack.getMeasures().size(); ++i) {
            Measure measure2 = (Measure)songTrack.getMeasures().get(i);
            if (measure != null && measure2.getStart() >= measure.getStart()) continue;
            measure = measure2;
        }
        return measure;
    }

    public Measure getLastMeasure(SongTrack songTrack) {
        int n = songTrack.getMeasures().size() - 1;
        return (Measure)songTrack.getMeasures().get(n);
    }

    public Measure getPrevMeasure(SongTrack songTrack, Measure measure) {
        int n = measure.getNumber() - 1;
        if (n > 0) {
            return (Measure)songTrack.getMeasures().get(n - 1);
        }
        return null;
    }

    public Measure getNextMeasure(SongTrack songTrack, Measure measure) {
        int n = measure.getNumber();
        if (n < songTrack.getMeasures().size()) {
            return (Measure)songTrack.getMeasures().get(n);
        }
        return null;
    }

    public Measure getMeasureAt(SongTrack songTrack, long l) {
        for (Measure measure : songTrack.getMeasures()) {
            long l2 = measure.getStart();
            long l3 = measure.getLength();
            if (l < l2 || l >= l2 + l3) continue;
            return measure;
        }
        return null;
    }

    public Measure getMeasure(SongTrack songTrack, int n) {
        for (int i = 0; i < songTrack.getMeasures().size(); ++i) {
            Measure measure = (Measure)songTrack.getMeasures().get(i);
            if (measure.getNumber() != n) continue;
            return measure;
        }
        return null;
    }

    public List getMeasuresBeforeEnd(SongTrack songTrack, long l) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : songTrack.getMeasures()) {
            if (measure.getStart() < l) continue;
            arrayList.add(measure);
        }
        return arrayList;
    }

    public List getMeasuresBetween(SongTrack songTrack, long l, long l2) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : songTrack.getMeasures()) {
            long l3 = measure.getStart();
            if (l3 < l || l3 > l2) continue;
            arrayList.add(measure);
        }
        return arrayList;
    }

    public void addNewMeasureBeforeEnd(SongTrack songTrack, MeasureHeader measureHeader) {
        this.addNewMeasureAfter(songTrack, measureHeader, this.getLastMeasure(songTrack));
    }

    public void addNewMeasureAfter(SongTrack songTrack, MeasureHeader measureHeader, Measure measure) {
        int n = measure.getClef();
        int n2 = measure.getKeySignature();
        this.addMeasure(songTrack, new Measure(measureHeader, new ArrayList(), new ArrayList(), n, n2));
    }

    public void addNewMeasure(SongTrack songTrack, MeasureHeader measureHeader) {
        Measure measure = this.getMeasure(songTrack, measureHeader.getNumber() == 1 ? measureHeader.getNumber() + 1 : measureHeader.getNumber() - 1);
        int n = measure.getClef();
        int n2 = measure.getKeySignature();
        this.addMeasure(songTrack, measureHeader.getNumber() - 1, new Measure(measureHeader, new ArrayList(), new ArrayList(), n, n2));
    }

    public List copyMeasures(SongTrack songTrack, long l, long l2) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : this.getMeasuresBetween(songTrack, l, l2)) {
            arrayList.add(measure);
        }
        return arrayList;
    }

    public void insertMeasures(SongTrack songTrack, List list, int n) {
        long l = -1L;
        long l2 = 0L;
        if (!list.isEmpty()) {
            l = ((Measure)list.get(0)).getStart();
            l2 = ((Measure)list.get(list.size() - 1)).getStart() + ((Measure)list.get(list.size() - 1)).getLength();
            for (Measure measure : list) {
                this.addMeasure(songTrack, measure.getNumber() - 1, measure);
                ++n;
            }
        }
    }

    public void addMeasure(SongTrack songTrack, Measure measure) {
        songTrack.getMeasures().add(measure);
    }

    public void addMeasure(SongTrack songTrack, int n, Measure measure) {
        songTrack.getMeasures().add(n, measure);
    }

    public void removeLastMeasure(SongTrack songTrack) {
        this.removeMeasure(songTrack, this.getLastMeasure(songTrack));
    }

    public void removeMeasure(SongTrack songTrack, long l) {
        this.removeMeasure(songTrack, this.getMeasureAt(songTrack, l));
    }

    public void removeMeasure(SongTrack songTrack, Measure measure) {
        long l = measure.getStart();
        long l2 = measure.getLength();
        songTrack.getMeasures().remove(measure.getNumber() - 1);
    }

    public Measure replaceMeasure(SongTrack songTrack, Measure measure) {
        Measure measure2 = this.getMeasureAt(songTrack, measure.getStart());
        measure2.makeEqual(measure);
        return measure2;
    }

    public void moveMeasure(SongTrack songTrack, Measure measure, long l, int n) {
        this.songManager.getMeasureManager().moveAllNotes(measure, l);
        this.songManager.getMeasureManager().moveAllSilences(measure, l);
    }

    public void changeKeySignature(SongTrack songTrack, long l, int n, boolean bl) {
        this.changeKeySignature(songTrack, this.getMeasureAt(songTrack, l), n, bl);
    }

    public void changeKeySignature(SongTrack songTrack, Measure measure, int n, boolean bl) {
        measure.setKeySignature(n);
        if (bl) {
            List list = this.getMeasuresBeforeEnd(songTrack, measure.getStart() + 1L);
            for (Measure measure2 : list) {
                measure2.setKeySignature(n);
            }
        }
    }

    public void changeClef(SongTrack songTrack, long l, int n, boolean bl) {
        this.changeClef(songTrack, this.getMeasureAt(songTrack, l), n, bl);
    }

    public void changeClef(SongTrack songTrack, Measure measure, int n, boolean bl) {
        measure.setClef(n);
        if (bl) {
            List list = this.getMeasuresBeforeEnd(songTrack, measure.getStart() + 1L);
            for (Measure measure2 : list) {
                measure2.setClef(n);
            }
        }
    }

    public void changeInfo(SongTrack songTrack, String string, RGBColor rGBColor, int n) {
        songTrack.setName(string);
        songTrack.setColor(rGBColor);
        songTrack.setOffset(n);
    }

    public void changeInstrumentStrings(SongTrack songTrack, List list) {
        if (list.size() < songTrack.getStrings().size()) {
            this.removeNotesAfterString(songTrack, list.size());
        }
        songTrack.setStrings(list);
    }

    public void removeNotesAfterString(SongTrack songTrack, int n) {
        for (Measure measure : songTrack.getMeasures()) {
            this.songManager.getMeasureManager().removeNotesAfterString(measure, n);
        }
    }

    public void changeInstrument(SongTrack songTrack, int n, boolean bl) {
        songTrack.getChannel().setInstrument((short)n);
        if (bl) {
            songTrack.getChannel().setChannel((short)9);
            songTrack.getChannel().setEffectChannel((short)9);
            songTrack.setStrings(SongManager.createPercusionStrings(songTrack.getStrings().size()));
        } else if (songTrack.getChannel().isPercusionChannel()) {
            SongChannel songChannel = this.songManager.getFreeChannel((short)n, false);
            songTrack.getChannel().setChannel(songChannel.getChannel());
            songTrack.getChannel().setEffectChannel(songChannel.getEffectChannel());
        }
        this.songManager.updateChannel(songTrack.getChannel());
    }

    public void autoCompleteSilences(SongTrack songTrack) {
        for (Measure measure : songTrack.getMeasures()) {
            this.songManager.getMeasureManager().autoCompleteSilences(measure);
        }
    }

    public boolean isFirstMeasure(Measure measure) {
        return measure.getNumber() == 1;
    }

    public boolean isLastMeasure(SongTrack songTrack, Measure measure) {
        return this.countMeasures(songTrack) == measure.getNumber();
    }
}

