/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import org.herac.tuxguitar.player.base.MidiSequence;
import org.herac.tuxguitar.player.impl.MidiMessageUtils;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.TimeSignature;

public class MidiSequenceImpl
extends MidiSequence {
    private Sequence sequence;
    private Track[] midiTracks;

    public MidiSequenceImpl(SongManager songManager) {
        super(songManager.countTracks() + 2);
        this.init(songManager);
    }

    private void init(SongManager songManager) {
        try {
            this.sequence = new Sequence(0.0f, 1000);
            this.midiTracks = new Track[this.getTracks()];
            for (int i = 0; i < this.midiTracks.length; ++i) {
                this.midiTracks[i] = this.sequence.createTrack();
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void addEvent(int n, MidiEvent midiEvent) {
        if (n >= 0 && n < this.midiTracks.length) {
            this.midiTracks[n].add(midiEvent);
        }
    }

    public void addControlChange(long l, int n, int n2, int n3, int n4) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.controlChange(n2, n3, n4), l));
    }

    public void addNoteOff(long l, int n, int n2, int n3, int n4) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.noteOff(n2, n3, n4), l));
    }

    public void addNoteOn(long l, int n, int n2, int n3, int n4) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.noteOn(n2, n3, n4), l));
    }

    public void addPitchBend(long l, int n, int n2, int n3) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.pitchBend(n2, n3), l));
    }

    public void addProgramChange(long l, int n, int n2, int n3) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.programChange(n2, n3), l));
    }

    public void addTempoInUSQ(long l, int n, int n2) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.tempoInUSQ(n2), l));
    }

    public void addTimeSignature(long l, int n, TimeSignature timeSignature) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.timeSignature(timeSignature), l));
    }

    public void addTickMove(long l, int n, long l2) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.tickMove(l2), l));
    }
}

