/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.gui.system.config.items.SoundOption;
import org.herac.tuxguitar.gui.util.SystemError;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiSequenceParser;
import org.herac.tuxguitar.player.impl.MidiMessageUtils;
import org.herac.tuxguitar.player.impl.MidiMetaEventListener;
import org.herac.tuxguitar.player.impl.MidiSequenceImpl;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongTrack;

public class MidiPlayerImpl
implements MidiPlayer {
    private static final int MAX_CHANNELS = 16;
    private SongManager songManager = TuxGuitar.instance().getSongManager();
    private Sequencer sequencer;
    private Synthesizer synthesizer;
    private Receiver receiver;
    private Soundbank soundbank;
    private MidiMetaEventListener controller = new MidiMetaEventListener();
    private boolean running;
    private boolean paused;
    private boolean changeTickPosition;
    private long tickPosition;
    private boolean metronomeEnabled;
    private int metronomeTrack;
    private int infoTrack;
    private boolean anySolo;
    private List systemErrors = new ArrayList();

    public MidiPlayerImpl() {
        this.init();
        this.reset();
    }

    public void init() {
        try {
            this.getSynthesizer();
            this.getSequencer();
            boolean bl = TuxGuitar.instance().getConfig().getBooleanConfigValue("soundbank.custom");
            if (bl && !this.loadSoundbank(new File(TuxGuitar.instance().getConfig().getStringConfigValue("soundbank.custom.path")))) {
                this.systemErrors.add(SystemError.getError(TuxGuitar.getProperty("soundbank.error"), TuxGuitar.getProperty("soundbank.error.custom")));
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    private Sequencer getSequencer() throws MidiUnavailableException {
        if (this.sequencer == null) {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.addMetaEventListener(this.controller);
        }
        if (!this.sequencer.isOpen()) {
            this.sequencer.open();
        }
        return this.sequencer;
    }

    public Synthesizer getSynthesizer() throws MidiUnavailableException {
        if (this.synthesizer == null) {
            this.setSynthesizer(MidiSystem.getSynthesizer());
        }
        return this.synthesizer;
    }

    public Soundbank getSoundbank() {
        if (this.soundbank == null) {
            try {
                Synthesizer synthesizer = this.getSynthesizer();
                this.soundbank = synthesizer.getDefaultSoundbank();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
        return this.soundbank;
    }

    public void setSynthesizer(Synthesizer synthesizer) {
        try {
            this.soundbank = null;
            if (this.synthesizer != null && this.synthesizer.isOpen()) {
                this.synthesizer.close();
            }
            this.synthesizer = synthesizer;
            if (this.synthesizer != null) {
                this.synthesizer.open();
                this.connect(this.synthesizer.getReceiver());
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void connect(Receiver receiver) {
        this.receiver = receiver;
        this.connect();
    }

    public void connect() {
        try {
            Iterator<Transmitter> iterator = this.getSequencer().getTransmitters().iterator();
            while (iterator.hasNext()) {
                iterator.next().close();
            }
            Transmitter transmitter = this.getSequencer().getTransmitter();
            transmitter.setReceiver(this.receiver);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void reset() {
        this.stop();
        this.tickPosition = 1000L;
        this.setChangeTickPosition(false);
        this.controller.reset();
    }

    public void close() {
        this.stop();
        this.soundbank = null;
        if (this.synthesizer != null) {
            this.synthesizer.close();
            this.synthesizer = null;
        }
        if (this.sequencer != null) {
            this.sequencer.close();
            this.sequencer = null;
        }
    }

    public void stop(boolean bl) {
        this.setPaused(bl);
        try {
            if (this.isRunning() && this.getSequencer().isOpen()) {
                this.allNotesOff();
                this.systemReset();
                this.getSequencer().stop();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        this.setRunning(false);
    }

    public void stop() {
        this.stop(false);
    }

    public void pause() {
        this.stop(true);
    }

    public synchronized void play() {
        try {
            this.stop();
            this.addSecuence();
            this.updatePrograms();
            this.updateControllers();
            this.updateDefaultControllers();
            this.setMetronomeEnabled(this.isMetronomeEnabled());
            this.setChangeTickPosition(true);
            this.setRunning(true);
            this.getSequencer().start();
            new Thread(new Runnable(){

                public synchronized void run() {
                    try {
                        while (MidiPlayerImpl.this.getSequencer().isRunning() && MidiPlayerImpl.this.isRunning()) {
                            if (MidiPlayerImpl.this.isChangeTickPosition()) {
                                MidiPlayerImpl.this.changeTickPosition();
                            }
                            MidiPlayerImpl.this.tickPosition = MidiPlayerImpl.this.getSequencer().getTickPosition();
                            Thread.sleep(10L);
                        }
                        if (MidiPlayerImpl.this.isRunning()) {
                            if (MidiPlayerImpl.this.tickPosition >= MidiPlayerImpl.this.getSequencer().getTickLength() - 500L) {
                                MidiPlayerImpl.this.reset();
                            } else {
                                MidiPlayerImpl.this.stop(MidiPlayerImpl.this.isPaused());
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        MidiPlayerImpl.this.reset();
                        midiUnavailableException.printStackTrace();
                    }
                }
            }).start();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            this.reset();
            midiUnavailableException.printStackTrace();
        }
    }

    public void send(MidiMessage midiMessage) {
        if (this.receiver != null) {
            this.receiver.send(midiMessage, -1L);
        }
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    private boolean isChangeTickPosition() {
        return this.changeTickPosition;
    }

    private void setChangeTickPosition(boolean bl) {
        this.changeTickPosition = bl;
    }

    public void setTickPosition(long l) {
        this.setTickPosition(l, this.controller.getMove());
    }

    public void setTickPosition(long l, long l2) {
        this.tickPosition = l;
        this.controller.setMove(l2);
        this.setChangeTickPosition(true);
        if (!this.isRunning()) {
            this.changeTickPosition();
        }
    }

    public long getTickPosition() {
        return this.tickPosition - this.controller.getMove();
    }

    private void changeTickPosition() {
        try {
            if (this.isRunning()) {
                this.getSequencer().setTickPosition(this.tickPosition);
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        this.setChangeTickPosition(false);
    }

    public void addSecuence() {
        try {
            MidiSequenceParser midiSequenceParser = new MidiSequenceParser(this.songManager, 12);
            MidiSequenceImpl midiSequenceImpl = new MidiSequenceImpl(this.songManager);
            midiSequenceParser.parse(midiSequenceImpl);
            this.getSequencer().setSequence(midiSequenceImpl.getSequence());
            this.infoTrack = midiSequenceImpl.getInfoTrack();
            this.metronomeTrack = midiSequenceImpl.getMetronomeTrack();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    private void updateDefaultControllers() {
        for (int i = 0; i < 16; ++i) {
            this.send(MidiMessageUtils.controlChange(i, 100, 0));
            this.send(MidiMessageUtils.controlChange(i, 101, 0));
            this.send(MidiMessageUtils.controlChange(i, 6, 12));
            this.send(MidiMessageUtils.controlChange(i, 101, 0));
            this.send(MidiMessageUtils.controlChange(i, 100, 1));
            this.send(MidiMessageUtils.controlChange(i, 6, 64));
            this.send(MidiMessageUtils.controlChange(i, 100, 127));
        }
    }

    public void updatePrograms() {
        for (SongTrack songTrack : this.songManager.getSong().getTracks()) {
            this.send(MidiMessageUtils.programChange(songTrack.getChannel().getChannel(), songTrack.getChannel().getInstrument()));
            if (songTrack.getChannel().getChannel() == songTrack.getChannel().getEffectChannel()) continue;
            this.send(MidiMessageUtils.programChange(songTrack.getChannel().getEffectChannel(), songTrack.getChannel().getInstrument()));
        }
    }

    public void updateControllers() {
        try {
            this.anySolo = false;
            for (SongTrack songTrack : this.songManager.getSong().getTracks()) {
                this.updateController(songTrack);
                this.anySolo = !this.anySolo ? songTrack.getChannel().isSolo() : this.anySolo;
            }
            this.afterUpdate();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    private void updateController(SongTrack songTrack) throws MidiUnavailableException {
        int n = (int)((double)this.songManager.getSong().getVolume() / 10.0 * (double)songTrack.getChannel().getVolume());
        short s = songTrack.getChannel().getBalance();
        this.updateController(songTrack.getChannel().getChannel(), n, s);
        if (songTrack.getChannel().getChannel() != songTrack.getChannel().getEffectChannel()) {
            this.updateController(songTrack.getChannel().getEffectChannel(), n, s);
        }
        this.getSequencer().setTrackMute(songTrack.getNumber(), songTrack.getChannel().isMute());
        this.getSequencer().setTrackSolo(songTrack.getNumber(), songTrack.getChannel().isSolo());
    }

    private void updateController(int n, int n2, int n3) throws MidiUnavailableException {
        this.send(MidiMessageUtils.controlChange(n, 7, n2));
        this.send(MidiMessageUtils.controlChange(n, 10, n3));
    }

    private void afterUpdate() throws MidiUnavailableException {
        this.getSequencer().setTrackSolo(this.infoTrack, this.anySolo);
        this.getSequencer().setTrackSolo(this.metronomeTrack, this.isMetronomeEnabled() && this.anySolo);
    }

    public boolean isMetronomeEnabled() {
        return this.metronomeEnabled;
    }

    public void setMetronomeEnabled(boolean bl) {
        try {
            this.metronomeEnabled = bl;
            this.getSequencer().setTrackMute(this.metronomeTrack, !this.isMetronomeEnabled());
            this.getSequencer().setTrackSolo(this.metronomeTrack, this.isMetronomeEnabled() && this.anySolo);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    public void allNotesOff() {
        for (int i = 0; i < 16; ++i) {
            this.send(MidiMessageUtils.controlChange(i, 123, 0));
        }
    }

    private void systemReset() {
        this.send(MidiMessageUtils.systemReset());
    }

    public void playBeat(final SongTrack songTrack, List list) {
        final short s = songTrack.getChannel().getChannel();
        short s2 = songTrack.getChannel().getInstrument();
        int n = (int)((double)this.songManager.getSong().getVolume() / 10.0 * (double)songTrack.getChannel().getVolume());
        short s3 = songTrack.getChannel().getBalance();
        this.send(MidiMessageUtils.programChange(s, s2));
        this.send(MidiMessageUtils.controlChange(s, 7, n));
        this.send(MidiMessageUtils.controlChange(s, 10, s3));
        for (final Note note : list) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        int n = songTrack.getOffset() + (note.getValue() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue());
                        int n2 = note.getVelocity();
                        MidiPlayerImpl.this.send(MidiMessageUtils.noteOn(s, n, n2));
                        Thread.sleep(500L);
                        MidiPlayerImpl.this.send(MidiMessageUtils.noteOff(s, n, n2));
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public boolean loadSoundbank(File file) {
        try {
            Soundbank soundbank = MidiSystem.getSoundbank(file);
            if (soundbank != null && this.getSynthesizer().isSoundbankSupported(soundbank)) {
                if (this.getSoundbank() != null) {
                    this.getSynthesizer().unloadAllInstruments(this.getSoundbank());
                }
                this.getSynthesizer().loadAllInstruments(soundbank);
                this.soundbank = soundbank;
                return true;
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public void write(OutputStream outputStream) {
        try {
            MidiSequenceParser midiSequenceParser = new MidiSequenceParser(this.songManager, 19);
            MidiSequenceImpl midiSequenceImpl = new MidiSequenceImpl(this.songManager);
            midiSequenceParser.parse(midiSequenceImpl);
            MidiSystem.write(midiSequenceImpl.getSequence(), 1, outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getInstrumentName(int n) {
        Object var2_2 = null;
        Soundbank soundbank = this.getSoundbank();
        if (soundbank != null) {
            Instrument[] instrumentArray = soundbank.getInstruments();
            if (n >= 0 && n < instrumentArray.length) {
                return instrumentArray[n].getName();
            }
        }
        return Integer.toString(n);
    }

    public List getSystemErrors() {
        return this.systemErrors;
    }

    public Option getConfigOption(ConfigEditor configEditor, ToolBar toolBar, Composite composite) {
        return new SoundOption(configEditor, toolBar, composite);
    }
}

