/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import org.herac.tuxguitar.song.models.TimeSignature;

public class MidiMessageUtils {
    public static final byte TICK_MOVE = 1;

    private static int getValue(int n) {
        n = n > 127 ? 127 : n;
        n = n < 0 ? 0 : n;
        return n;
    }

    private static int getChannel(int n) {
        n = n > 15 ? 15 : n;
        n = n < 0 ? 0 : n;
        return n;
    }

    public static MidiMessage noteOn(int n, int n2, int n3) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(144, MidiMessageUtils.getChannel(n), MidiMessageUtils.getValue(n2), MidiMessageUtils.getValue(n3));
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage noteOff(int n, int n2, int n3) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(128, MidiMessageUtils.getChannel(n), MidiMessageUtils.getValue(n2), MidiMessageUtils.getValue(n3));
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage controlChange(int n, int n2, int n3) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(176, MidiMessageUtils.getChannel(n), MidiMessageUtils.getValue(n2), MidiMessageUtils.getValue(n3));
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage programChange(int n, int n2) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(192, MidiMessageUtils.getChannel(n), MidiMessageUtils.getValue(n2), 0);
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage pitchBend(int n, int n2) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(224, MidiMessageUtils.getChannel(n), 0, MidiMessageUtils.getValue(n2));
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage systemReset() {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(255);
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage tempoInUSQ(int n) {
        try {
            MetaMessage metaMessage = new MetaMessage();
            metaMessage.setMessage(81, new byte[]{(byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)}, 3);
            return metaMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage timeSignature(TimeSignature timeSignature) {
        try {
            MetaMessage metaMessage = new MetaMessage();
            metaMessage.setMessage(88, new byte[]{(byte)timeSignature.getNumerator(), (byte)timeSignature.getDenominator().log2(), (byte)(96 / timeSignature.getDenominator().getValue()), 8}, 4);
            return metaMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage tickMove(long l) {
        try {
            byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
            MetaMessage metaMessage = new MetaMessage();
            metaMessage.setMessage(1, byArray, byArray.length);
            return metaMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }
}

