/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.tg.TGStream;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Lyric;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;
import org.herac.tuxguitar.song.models.effects.BendEffect;
import org.herac.tuxguitar.song.models.effects.GraceEffect;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;
import org.herac.tuxguitar.song.models.effects.TremoloBarEffect;
import org.herac.tuxguitar.song.models.effects.TremoloPickingEffect;
import org.herac.tuxguitar.song.models.effects.TrillEffect;

public class TGOutputStream
extends TGStream {
    private DataOutputStream dataOutputStream;

    public TGOutputStream(FileOutputStream fileOutputStream) throws FileNotFoundException {
        this.dataOutputStream = new DataOutputStream(fileOutputStream);
    }

    public TGOutputStream(String string) throws FileNotFoundException {
        this(new FileOutputStream(new File(string)));
    }

    public void write(Song song) {
        try {
            this.writeVersion();
            this.writeSong(song);
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeVersion() {
        this.writeString("TuxGuitar File Format - 0.9");
    }

    private void writeSong(Song song) {
        Serializable serializable;
        int n;
        this.writeString(song.getName());
        this.writeString(song.getInterpret());
        this.writeString(song.getAlbum());
        this.writeString(song.getAuthor());
        this.writeShort((short)song.getMeasureHeaders().size());
        MeasureHeader measureHeader = null;
        for (n = 0; n < song.getMeasureHeaders().size(); ++n) {
            serializable = (MeasureHeader)song.getMeasureHeaders().get(n);
            this.writeMeasureHeader((MeasureHeader)serializable, measureHeader);
            measureHeader = serializable;
        }
        this.writeByte(song.getTracks().size());
        for (n = 0; n < song.getTracks().size(); ++n) {
            serializable = (SongTrack)song.getTracks().get(n);
            this.writeTrack((SongTrack)serializable);
        }
    }

    private void writeTrack(SongTrack songTrack) {
        int n = 0;
        if (!songTrack.getLyrics().isEmpty()) {
            n |= 1;
        }
        this.writeHeader(n);
        this.writeString(songTrack.getName());
        this.writeChannel(songTrack.getChannel());
        Measure measure = null;
        for (Object object : songTrack.getMeasures()) {
            this.writeMeasure((Measure)object, measure);
            measure = object;
        }
        this.writeByte(songTrack.getStrings().size());
        for (InstrumentString instrumentString : songTrack.getStrings()) {
            this.writeInstrumentString(instrumentString);
        }
        this.writeByte(songTrack.getOffset() - -24);
        this.writeRGBColor(songTrack.getColor());
        if ((n & 1) != 0) {
            this.writeLyrics(songTrack.getLyrics());
        }
    }

    private void writeMeasureHeader(MeasureHeader measureHeader, MeasureHeader measureHeader2) {
        int n = 0;
        if (measureHeader2 == null) {
            n |= 1;
            n |= 2;
            if (measureHeader.getTripletFeel() != 1) {
                n |= 0x20;
            }
        } else {
            int n2 = measureHeader.getTimeSignature().getNumerator();
            int n3 = measureHeader.getTimeSignature().getDenominator().getValue();
            int n4 = measureHeader2.getTimeSignature().getNumerator();
            int n5 = measureHeader2.getTimeSignature().getDenominator().getValue();
            if (n2 != n4 || n3 != n5) {
                n |= 1;
            }
            if (measureHeader.getTempo().getValue() != measureHeader2.getTempo().getValue()) {
                n |= 2;
            }
            if (measureHeader.getTripletFeel() != measureHeader2.getTripletFeel()) {
                n |= 0x20;
            }
        }
        n = measureHeader.isRepeatStart() ? (n = n | 4) : n;
        n = measureHeader.getNumberOfRepetitions() > 0 ? (n = n | 8) : n;
        n = measureHeader.hasMarker() ? (n = n | 0x10) : n;
        this.writeHeader(n);
        if ((n & 1) != 0) {
            this.writeTimeSignature(measureHeader.getTimeSignature());
        }
        if ((n & 2) != 0) {
            this.writeTempo(measureHeader.getTempo());
        }
        if ((n & 8) != 0) {
            this.writeShort((short)measureHeader.getNumberOfRepetitions());
        }
        if ((n & 0x10) != 0) {
            this.writeMarker(measureHeader.getMarker());
        }
        if ((n & 0x20) != 0) {
            this.writeByte(measureHeader.getTripletFeel());
        }
    }

    private void writeMeasure(Measure measure, Measure measure2) {
        int n = 0;
        if (measure2 == null) {
            n |= 1;
            n |= 2;
        } else {
            if (measure.getClef() != measure2.getClef()) {
                n |= 1;
            }
            if (measure.getKeySignature() != measure2.getKeySignature()) {
                n |= 2;
            }
        }
        this.writeHeader(n);
        List list = this.getMeasureComponents(measure);
        this.writeShort((short)list.size());
        Component component = null;
        for (Component component2 : list) {
            this.writeComponent(component2, component);
            component = component2;
        }
        if ((n & 1) != 0) {
            this.writeByte(measure.getClef());
        }
        if ((n & 2) != 0) {
            this.writeByte(measure.getKeySignature());
        }
    }

    private void writeChannel(SongChannel songChannel) {
        int n = 0;
        n = songChannel.isSolo() ? (n = n | 1) : n;
        n = songChannel.isMute() ? (n = n | 2) : n;
        this.writeHeader(n);
        this.writeByte(songChannel.getChannel());
        this.writeByte(songChannel.getEffectChannel());
        this.writeByte(songChannel.getInstrument());
        this.writeByte(songChannel.getVolume());
        this.writeByte(songChannel.getBalance());
        this.writeByte(songChannel.getChorus());
        this.writeByte(songChannel.getReverb());
        this.writeByte(songChannel.getPhaser());
        this.writeByte(songChannel.getTremolo());
    }

    private void writeComponent(Component component, Component component2) {
        Note note;
        int n = 0;
        if (component instanceof Note) {
            note = (Note)component;
            n |= 1;
            n = note.isTiedNote() ? (n = n | 4) : n;
            n = !(component2 instanceof Note) && note.getVelocity() != 95 ? (n = n | 0x40) : n;
            n = component2 instanceof Note && note.getVelocity() != ((Note)component2).getVelocity() ? (n = n | 0x40) : n;
            n = note.getEffect().hasAnyEffect() ? (n = n | 8) : n;
        } else if (component instanceof Silence) {
            n |= 2;
        }
        n = component2 == null || component.getStart() != component2.getStart() ? (n = n | 0x10) : n;
        n = component2 == null || !component.getDuration().isEqual(component2.getDuration()) ? (n = n | 0x20) : n;
        this.writeHeader(n);
        if ((n & 0x20) != 0) {
            this.writeDuration(component.getDuration());
        }
        if ((n & 1) != 0) {
            note = (Note)component;
            this.writeByte(note.getValue());
            this.writeByte(note.getString());
            if ((n & 0x40) != 0) {
                this.writeByte(note.getVelocity());
            }
            if ((n & 8) != 0) {
                this.writeNoteEffect(note.getEffect());
            }
        }
    }

    private void writeInstrumentString(InstrumentString instrumentString) {
        this.writeByte(instrumentString.getValue());
    }

    private void writeTempo(Tempo tempo) {
        this.writeShort((short)tempo.getValue());
    }

    private void writeTimeSignature(TimeSignature timeSignature) {
        this.writeByte(timeSignature.getNumerator());
        this.writeDuration(timeSignature.getDenominator());
    }

    private void writeDuration(Duration duration) {
        int n = 0;
        n = duration.isDotted() ? (n = n | 1) : n;
        n = duration.isDoubleDotted() ? (n = n | 2) : n;
        n = !duration.getTupleto().isEqual(Duration.NO_TUPLETO) ? (n = n | 4) : n;
        this.writeHeader(n);
        this.writeByte(duration.getValue());
        if ((n & 4) != 0) {
            this.writeTupleto(duration.getTupleto());
        }
    }

    private void writeTupleto(Tupleto tupleto) {
        this.writeByte(tupleto.getEnters());
        this.writeByte(tupleto.getTimes());
    }

    private void writeNoteEffect(NoteEffect noteEffect) {
        int n = 0;
        n = noteEffect.isBend() ? (n = n | 1) : n;
        n = noteEffect.isTremoloBar() ? (n = n | 2) : n;
        n = noteEffect.isHarmonic() ? (n = n | 4) : n;
        n = noteEffect.isGrace() ? (n = n | 8) : n;
        n = noteEffect.isTrill() ? (n = n | 0x10) : n;
        n = noteEffect.isTremoloPicking() ? (n = n | 0x20) : n;
        n = noteEffect.isVibrato() ? (n = n | 0x40) : n;
        n = noteEffect.isDeadNote() ? (n = n | 0x80) : n;
        n = noteEffect.isSlide() ? (n = n | 0x100) : n;
        n = noteEffect.isHammer() ? (n = n | 0x200) : n;
        n = noteEffect.isGhostNote() ? (n = n | 0x400) : n;
        n = noteEffect.isAccentuatedNote() ? (n = n | 0x800) : n;
        n = noteEffect.isHeavyAccentuatedNote() ? (n = n | 0x1000) : n;
        n = noteEffect.isPalmMute() ? (n = n | 0x2000) : n;
        n = noteEffect.isStaccato() ? (n = n | 0x4000) : n;
        n = noteEffect.isTapping() ? (n = n | 0x8000) : n;
        n = noteEffect.isSlapping() ? (n = n | 0x10000) : n;
        n = noteEffect.isPopping() ? (n = n | 0x20000) : n;
        n = noteEffect.isFadeIn() ? (n = n | 0x40000) : n;
        this.writeHeader(n, 3);
        if ((n & 1) != 0) {
            this.writeBendEffect(noteEffect.getBend());
        }
        if ((n & 2) != 0) {
            this.writeTremoloBarEffect(noteEffect.getTremoloBar());
        }
        if ((n & 4) != 0) {
            this.writeHarmonicEffect(noteEffect.getHarmonic());
        }
        if ((n & 8) != 0) {
            this.writeGraceEffect(noteEffect.getGrace());
        }
        if ((n & 0x10) != 0) {
            this.writeTrillEffect(noteEffect.getTrill());
        }
        if ((n & 0x20) != 0) {
            this.writeTremoloPickingEffect(noteEffect.getTremoloPicking());
        }
    }

    private void writeBendEffect(BendEffect bendEffect) {
        this.writeByte(bendEffect.getPoints().size());
        for (BendEffect.BendPoint bendPoint : bendEffect.getPoints()) {
            this.writeByte(bendPoint.getPosition());
            this.writeByte(bendPoint.getValue());
        }
    }

    private void writeTremoloBarEffect(TremoloBarEffect tremoloBarEffect) {
        this.writeByte(tremoloBarEffect.getPoints().size());
        for (TremoloBarEffect.TremoloBarPoint tremoloBarPoint : tremoloBarEffect.getPoints()) {
            this.writeByte(tremoloBarPoint.getPosition());
            this.writeByte(tremoloBarPoint.getValue() + 12);
        }
    }

    private void writeHarmonicEffect(HarmonicEffect harmonicEffect) {
        this.writeByte(harmonicEffect.getType());
        if (harmonicEffect.getType() == 2) {
            this.writeByte(harmonicEffect.getData() - -24);
        } else if (harmonicEffect.getType() == 3) {
            this.writeByte(harmonicEffect.getData());
        }
    }

    private void writeGraceEffect(GraceEffect graceEffect) {
        int n = 0;
        n = graceEffect.isDead() ? (n = n | 1) : n;
        n = graceEffect.isOnBeat() ? (n = n | 2) : n;
        this.writeHeader(n);
        this.writeByte(graceEffect.getFret());
        this.writeByte(graceEffect.getDuration());
        this.writeByte(graceEffect.getDynamic());
        this.writeByte(graceEffect.getTransition());
    }

    private void writeTremoloPickingEffect(TremoloPickingEffect tremoloPickingEffect) {
        this.writeByte(tremoloPickingEffect.getDuration().getValue());
    }

    private void writeTrillEffect(TrillEffect trillEffect) {
        this.writeByte(trillEffect.getFret());
        this.writeByte(trillEffect.getDuration().getValue());
    }

    private void writeMarker(Marker marker) {
        this.writeString(marker.getTitle());
        this.writeRGBColor(marker.getColor());
    }

    private void writeRGBColor(RGBColor rGBColor) {
        this.writeShort((short)rGBColor.getR());
        this.writeShort((short)rGBColor.getG());
        this.writeShort((short)rGBColor.getB());
    }

    private void writeLyrics(Lyric lyric) {
        this.writeShort((short)lyric.getFrom());
        this.writeString(lyric.getLyrics());
    }

    private List getMeasureComponents(Measure measure) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.addAll(measure.getNotes());
        arrayList.addAll(measure.getSilences());
        for (int i = 0; i < arrayList.size(); ++i) {
            Component component = null;
            for (int j = i; j < arrayList.size(); ++j) {
                Component component2 = (Component)arrayList.get(j);
                if (component != null && component2.getStart() >= component.getStart()) continue;
                component = component2;
            }
            arrayList.remove(component);
            arrayList.add(i, component);
        }
        return arrayList;
    }

    public void writeByte(int n) {
        try {
            this.dataOutputStream.write(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeString(String string) {
        try {
            this.dataOutputStream.write(string.length());
            this.dataOutputStream.writeChars(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeHeader(int n) {
        try {
            this.dataOutputStream.write(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeHeader(int n, int n2) {
        for (int i = n2; i > 0; --i) {
            this.writeHeader(n >>> 8 * i - 8 & 0xFF);
        }
    }

    public void writeShort(short s) {
        try {
            this.dataOutputStream.writeShort(s);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

