/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.tg.TGStream;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Lyric;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;
import org.herac.tuxguitar.song.models.effects.BendEffect;
import org.herac.tuxguitar.song.models.effects.GraceEffect;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;
import org.herac.tuxguitar.song.models.effects.TremoloBarEffect;
import org.herac.tuxguitar.song.models.effects.TremoloPickingEffect;
import org.herac.tuxguitar.song.models.effects.TrillEffect;

public class TGInputStream
extends TGStream {
    private DataInputStream dataInputStream;
    private String version;

    public TGInputStream(FileInputStream fileInputStream) throws FileNotFoundException {
        this.dataInputStream = new DataInputStream(fileInputStream);
    }

    public TGInputStream(String string) throws FileNotFoundException {
        this(new FileInputStream(new File(string)));
    }

    public boolean isSupportedVersion(String string) {
        return string.equals("TuxGuitar File Format - 0.9");
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return this.isSupportedVersion(this.version);
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
    }

    public Song read() {
        try {
            this.readVersion();
            Song song = this.readSong();
            this.dataInputStream.close();
            return song;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void readVersion() {
        if (this.version == null) {
            this.version = this.readString();
        }
    }

    private Song readSong() {
        Serializable serializable;
        int n;
        String string = this.readString();
        String string2 = this.readString();
        String string3 = this.readString();
        String string4 = this.readString();
        int n2 = this.readShort();
        long l = 1000L;
        Serializable serializable2 = null;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(n2);
        for (n = 0; n < n2; ++n) {
            serializable = this.readMeasureHeader(n + 1, l, (MeasureHeader)serializable2);
            arrayList.add(serializable);
            l += ((MeasureHeader)serializable).getLength();
            serializable2 = serializable;
        }
        n = this.readByte();
        serializable = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            serializable.add(this.readTrack(i + 1, arrayList));
        }
        return new Song(string, string2, string3, string4, (List)((Object)serializable), arrayList, 10);
    }

    private SongTrack readTrack(int n, List list) {
        int n2;
        Serializable serializable;
        int n3;
        int n4 = this.readHeader();
        String string = this.readString();
        SongChannel songChannel = this.readChannel();
        int n5 = list.size();
        Serializable serializable2 = null;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(n5);
        for (n3 = 0; n3 < n5; ++n3) {
            serializable = this.readMeasure((MeasureHeader)list.get(n3), (Measure)serializable2);
            arrayList.add(serializable);
            serializable2 = serializable;
        }
        n3 = this.readByte();
        serializable = new ArrayList(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            serializable.add(this.readInstrumentString(n2 + 1));
        }
        n2 = -24 + this.readByte();
        RGBColor rGBColor = this.readRGBColor();
        Lyric lyric = new Lyric();
        if ((n4 & 1) != 0) {
            lyric = this.readLyrics();
        }
        return new SongTrack(n, string, songChannel, arrayList, (List)((Object)serializable), n2, rGBColor, lyric);
    }

    private MeasureHeader readMeasureHeader(int n, long l, MeasureHeader measureHeader) {
        int n2;
        int n3 = this.readHeader();
        TimeSignature timeSignature = null;
        timeSignature = (n3 & 1) != 0 ? this.readTimeSignature() : (TimeSignature)measureHeader.getTimeSignature().clone();
        Tempo tempo = null;
        tempo = (n3 & 2) != 0 ? this.readTempo() : (Tempo)measureHeader.getTempo().clone();
        boolean bl = (n3 & 4) != 0;
        short s = 0;
        if ((n3 & 8) != 0) {
            s = this.readShort();
        }
        Marker marker = null;
        if ((n3 & 0x10) != 0) {
            marker = this.readMarker(n);
        }
        int n4 = n2 = measureHeader != null ? measureHeader.getTripletFeel() : 1;
        if ((n3 & 0x20) != 0) {
            n2 = this.readByte();
        }
        return new MeasureHeader(n, l, timeSignature, tempo, marker, n2, bl, s);
    }

    private Measure readMeasure(MeasureHeader measureHeader, Measure measure) {
        int n;
        int n2 = this.readHeader();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Component component = null;
        int n3 = this.readShort();
        for (n = 0; n < n3; ++n) {
            component = this.readComponent(measureHeader, arrayList, arrayList2, component);
        }
        n = 0;
        n = (n2 & 1) != 0 ? this.readByte() : measure.getClef();
        int n4 = 0;
        n4 = (n2 & 2) != 0 ? this.readByte() : measure.getKeySignature();
        return new Measure(measureHeader, arrayList, arrayList2, n, n4);
    }

    private SongChannel readChannel() {
        int n = this.readHeader();
        short s = (short)this.readByte();
        short s2 = (short)this.readByte();
        short s3 = (short)this.readByte();
        short s4 = (short)this.readByte();
        short s5 = (short)this.readByte();
        short s6 = (short)this.readByte();
        short s7 = (short)this.readByte();
        short s8 = (short)this.readByte();
        short s9 = (short)this.readByte();
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        return new SongChannel(s, s2, s3, s4, s5, s6, s7, s8, s9, bl, bl2);
    }

    private Component readComponent(MeasureHeader measureHeader, List list, List list2, Component component) {
        int n = this.readHeader();
        long l = 0L;
        l = component == null ? measureHeader.getStart() : ((n & 0x10) != 0 ? component.getStart() + component.getDuration().getTime() : component.getStart());
        Duration duration = null;
        duration = (n & 0x20) != 0 ? this.readDuration() : (Duration)component.getDuration().clone();
        if ((n & 1) != 0) {
            int n2;
            int n3 = this.readByte();
            int n4 = this.readByte();
            boolean bl = (n & 4) != 0;
            int n5 = n2 = component instanceof Note ? ((Note)component).getVelocity() : 95;
            if ((n & 0x40) != 0) {
                n2 = this.readByte();
            }
            NoteEffect noteEffect = new NoteEffect();
            if ((n & 8) != 0) {
                noteEffect = this.readNoteEffect();
            }
            Note note = new Note(n3, l, duration, n2, n4, bl, noteEffect);
            list.add(note);
            return note;
        }
        if ((n & 2) != 1) {
            Silence silence = new Silence(l, duration);
            list2.add(silence);
            return silence;
        }
        return null;
    }

    private InstrumentString readInstrumentString(int n) {
        int n2 = this.readByte();
        return new InstrumentString(n, n2);
    }

    private Tempo readTempo() {
        short s = this.readShort();
        return new Tempo(s);
    }

    private TimeSignature readTimeSignature() {
        int n = this.readByte();
        Duration duration = this.readDuration();
        return new TimeSignature(n, duration);
    }

    private Duration readDuration() {
        int n = this.readHeader();
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        int n2 = this.readByte();
        Tupleto tupleto = Duration.NO_TUPLETO;
        if ((n & 4) != 0) {
            tupleto = this.readTupleto();
        }
        return new Duration(n2, bl, bl2, tupleto);
    }

    private Tupleto readTupleto() {
        int n = this.readByte();
        int n2 = this.readByte();
        return new Tupleto(n, n2);
    }

    private NoteEffect readNoteEffect() {
        NoteEffect noteEffect = new NoteEffect();
        int n = this.readHeader(3);
        if ((n & 1) != 0) {
            noteEffect.setBend(this.readBendEffect());
        }
        if ((n & 2) != 0) {
            noteEffect.setTremoloBar(this.readTremoloBarEffect());
        }
        if ((n & 4) != 0) {
            noteEffect.setHarmonic(this.readHarmonicEffect());
        }
        if ((n & 8) != 0) {
            noteEffect.setGrace(this.readGraceEffect());
        }
        if ((n & 0x10) != 0) {
            noteEffect.setTrill(this.readTrillEffect());
        }
        if ((n & 0x20) != 0) {
            noteEffect.setTremoloPicking(this.readTremoloPickingEffect());
        }
        noteEffect.setVibrato((n & 0x40) != 0);
        noteEffect.setDeadNote((n & 0x80) != 0);
        noteEffect.setSlide((n & 0x100) != 0);
        noteEffect.setHammer((n & 0x200) != 0);
        noteEffect.setGhostNote((n & 0x400) != 0);
        noteEffect.setAccentuatedNote((n & 0x800) != 0);
        noteEffect.setHeavyAccentuatedNote((n & 0x1000) != 0);
        noteEffect.setPalmMute((n & 0x2000) != 0);
        noteEffect.setStaccato((n & 0x4000) != 0);
        noteEffect.setTapping((n & 0x8000) != 0);
        noteEffect.setSlapping((n & 0x10000) != 0);
        noteEffect.setPopping((n & 0x20000) != 0);
        noteEffect.setFadeIn((n & 0x40000) != 0);
        return noteEffect;
    }

    private BendEffect readBendEffect() {
        BendEffect bendEffect = new BendEffect();
        int n = this.readByte();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readByte();
            int n3 = this.readByte();
            bendEffect.addPoint(n2, n3);
        }
        return bendEffect;
    }

    private TremoloBarEffect readTremoloBarEffect() {
        TremoloBarEffect tremoloBarEffect = new TremoloBarEffect();
        int n = this.readByte();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readByte();
            int n3 = this.readByte() - 12;
            tremoloBarEffect.addPoint(n2, n3);
        }
        return tremoloBarEffect;
    }

    private HarmonicEffect readHarmonicEffect() {
        int n = this.readByte();
        int n2 = 0;
        if (n == 2) {
            n2 = -24 + this.readByte();
        } else if (n == 3) {
            n2 = this.readByte();
        }
        return new HarmonicEffect(n, n2);
    }

    private GraceEffect readGraceEffect() {
        int n = this.readHeader();
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readByte();
        int n5 = this.readByte();
        return new GraceEffect(n2, n3, n4, n5, bl2, bl);
    }

    private TremoloPickingEffect readTremoloPickingEffect() {
        int n = this.readByte();
        return new TremoloPickingEffect(n);
    }

    private TrillEffect readTrillEffect() {
        int n = this.readByte();
        int n2 = this.readByte();
        return new TrillEffect(n, n2);
    }

    private Marker readMarker(int n) {
        String string = this.readString();
        RGBColor rGBColor = this.readRGBColor();
        return new Marker(n, string, rGBColor);
    }

    private RGBColor readRGBColor() {
        short s = this.readShort();
        short s2 = this.readShort();
        short s3 = this.readShort();
        return new RGBColor(s, s2, s3);
    }

    private Lyric readLyrics() {
        short s = this.readShort();
        String string = this.readString();
        return new Lyric(s, string);
    }

    private int readByte() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private int readHeader() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private int readHeader(int n) {
        int n2 = 0;
        for (int i = n; i > 0; --i) {
            n2 += this.readHeader() << 8 * i - 8;
        }
        return n2;
    }

    private short readShort() {
        try {
            return this.dataInputStream.readShort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private String readString() {
        try {
            int n = this.dataInputStream.read();
            char[] cArray = new char[n];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = this.dataInputStream.readChar();
            }
            return String.copyValueOf(cArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

