/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pt;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.pt.PTBInputStream;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.TimeSignature;

public class PTB4InputStream
extends PTBInputStream {
    private static final long MIN_START = 1000L;
    private static final int nullTag = 0;
    private static final int NEW_TAG_CLASS = 65535;
    private static final int tagClass = 32768;
    private static final int BigTagClass = Integer.MIN_VALUE;
    private static final int objectTag = Short.MAX_VALUE;
    private static final int MaxMapCount = 0x3FFFFFFE;
    private static final String PTB_VERSION = "ptab-4";

    public PTB4InputStream(FileInputStream fileInputStream) throws FileNotFoundException {
        super(fileInputStream);
    }

    public PTB4InputStream(String string) throws FileNotFoundException {
        super(string);
    }

    public boolean isSupportedVersion(String string) {
        return string.equals(PTB_VERSION);
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return this.isSupportedVersion(this.version);
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
    }

    private void readVersion() {
        if (this.version == null) {
            this.version = this.readString(4) + "-" + this.readUInt();
        }
    }

    public Song readSong() throws IOException {
        this.readVersion();
        if (!this.isSupportedVersion(this.version)) {
            throw new IOException("Unsuported Version");
        }
        PTBInputStream.SongInfo songInfo = this.readSongInfo();
        this.readDataInstruments(1);
        this.readDataInstruments(2);
        return this.checkSong(new Song(songInfo.getName(), songInfo.getInterpret(), songInfo.getAlbum(), songInfo.getAuthor(), this.tracks, this.headers, 10));
    }

    private PTBInputStream.SongInfo readSongInfo() {
        PTBInputStream.SongInfo songInfo = new PTBInputStream.SongInfo(this);
        int n = this.readUCType();
        if (n == 0) {
            int n2;
            int n3;
            int n4;
            int n5 = this.readUCType();
            String string = this.readString();
            String string2 = this.readString();
            int n6 = this.readUCType();
            String string3 = new String();
            if (n6 == 0) {
                n4 = this.readUCType();
                string3 = this.readString();
                n3 = this.readUInt();
                n2 = this.readUChar();
            } else if (n6 == 1) {
                string3 = this.readString();
                n4 = this.readUChar() ? 1 : 0;
            } else if (n6 == 2) {
                string3 = this.readString();
                n4 = this.readUInt();
                n3 = this.readUInt();
                n2 = this.readUInt();
            }
            n4 = this.readUCType() == 0 ? 1 : 0;
            String string4 = new String();
            String string5 = new String();
            if (n4 != 0) {
                string4 = this.readString();
                string5 = this.readString();
            }
            String string6 = this.readString();
            String string7 = this.readString();
            String string8 = this.readString();
            String string9 = this.readString();
            String string10 = this.readString();
            String string11 = this.readString();
            String string12 = this.readString();
            songInfo.setName(string);
            songInfo.setAlbum(string3);
            songInfo.setInterpret(string2);
            songInfo.setAuthor(string4);
        } else if (n == 1) {
            String string = this.readString();
            String string13 = this.readString();
            int n7 = this.readUInt();
            int n8 = this.readUCType();
            String string14 = this.readString();
            String string15 = this.readString();
            String string16 = this.readString();
            songInfo.setName(string);
            songInfo.setAlbum(string13);
            songInfo.setAuthor(string14);
        }
        return songInfo;
    }

    private void readDataInstruments(int n) {
        int n2;
        int n3 = this.tracks.size();
        ArrayList<PTBInputStream.TempoHelper> arrayList = new ArrayList<PTBInputStream.TempoHelper>();
        ArrayList<PTBInputStream.GuitarInHelper> arrayList2 = new ArrayList<PTBInputStream.GuitarInHelper>();
        int n4 = this.readHeaderItems();
        for (n2 = 0; n2 < n4; ++n2) {
            this.readTrackInfo(n);
            if (n2 >= n4 - 1) continue;
            this.readUInt();
        }
        n4 = this.readHeaderItems();
        for (n2 = 0; n2 < n4; ++n2) {
            this.readChord();
            if (n2 >= n4 - 1) continue;
            this.readUInt();
        }
        n4 = this.readHeaderItems();
        for (n2 = 0; n2 < n4; ++n2) {
            this.readFloattingText();
            if (n2 >= n4 - 1) continue;
            this.readUInt();
        }
        n4 = this.readHeaderItems();
        for (n2 = 0; n2 < n4; ++n2) {
            arrayList2.add(this.readGuitarIn());
            if (n2 >= n4 - 1) continue;
            this.readUInt();
        }
        n4 = this.readHeaderItems();
        for (n2 = 0; n2 < n4; ++n2) {
            PTBInputStream.TempoHelper tempoHelper = this.readTempoMarker();
            if (tempoHelper != null) {
                arrayList.add(tempoHelper);
            }
            if (n2 >= n4 - 1) continue;
            this.readUInt();
        }
        n4 = this.readHeaderItems();
        for (n2 = 0; n2 < n4; ++n2) {
            this.readDynamic();
            if (n2 >= n4 - 1) continue;
            this.readUInt();
        }
        n4 = this.readHeaderItems();
        for (n2 = 0; n2 < n4; ++n2) {
            this.readSectionSymbol();
            if (n2 >= n4 - 1) continue;
            this.readUInt();
        }
        n2 = n3 + 1;
        long l = 1000L;
        n4 = this.readHeaderItems();
        for (int i = 0; i < n4; ++i) {
            l = this.readSection(n2, n, l, arrayList);
            if (i >= n4 - 1) continue;
            this.readUInt();
        }
        this.makeTrackChannels(n3, n, arrayList2);
    }

    private int readHeaderItems() {
        int n = this.readUInt();
        if (n == 0) {
            return 0;
        }
        int n2 = this.readUInt();
        if (n2 == 65535) {
            if (this.readUInt() != 1) {
                return -1;
            }
            String string = this.readString(this.readUInt());
        }
        return n;
    }

    private void readTrackInfo(int n) {
        PTBInputStream.TrackInfo trackInfo = new PTBInputStream.TrackInfo(this);
        trackInfo.setType(n);
        trackInfo.setChannel(new SongChannel(0, 0, 0));
        trackInfo.setStrings(new ArrayList());
        trackInfo.setTrackInfoNumber(this.readByte());
        trackInfo.setName(this.readString());
        trackInfo.getChannel().setInstrument((short)this.readByte());
        trackInfo.getChannel().setVolume((short)this.readByte());
        trackInfo.getChannel().setBalance((short)this.readByte());
        trackInfo.getChannel().setReverb((short)this.readByte());
        trackInfo.getChannel().setChorus((short)this.readByte());
        trackInfo.getChannel().setTremolo((short)this.readByte());
        trackInfo.getChannel().setPhaser((short)this.readByte());
        int n2 = this.readByte();
        String string = this.readString();
        int n3 = this.readByte();
        int n4 = this.readByte();
        for (int i = 1; i <= n4; ++i) {
            trackInfo.getStrings().add(new InstrumentString(i, this.readByte()));
        }
        this.trackInfos.add(trackInfo);
    }

    private void readChord() {
        int n = this.readUInt();
        this.readByte();
        int n2 = this.readUInt();
        this.readByte();
        this.readByte();
        int n3 = this.readByte();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.readByte();
        }
    }

    private void readFloattingText() {
        String string = this.readString();
        long l = this.readULong();
        long l2 = this.readULong();
        long l3 = this.readULong();
        long l4 = this.readULong();
        this.readByte();
        this.readFontSetting();
    }

    private void readFontSetting() {
        String string = this.readString();
        int n = this.readULong();
        int n2 = this.readULong();
        boolean bl = this.readUChar();
        boolean bl2 = this.readUChar();
        boolean bl3 = this.readUChar();
        int n3 = this.readULong();
    }

    private PTBInputStream.GuitarInHelper readGuitarIn() {
        int n = this.readUInt();
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readUInt();
        return new PTBInputStream.GuitarInHelper(this, n2 + 1, (n4 >> 8) - 1);
    }

    private PTBInputStream.TempoHelper readTempoMarker() {
        int n = this.readUInt();
        int n2 = this.readByte();
        int n3 = this.readUInt();
        int n4 = this.readUInt();
        String string = this.readString();
        int n5 = 1;
        if ((n4 & 1) != 0) {
            n5 = 2;
        } else if ((n4 & 2) != 0) {
            n5 = 3;
        }
        if (n3 > 0 && n == 0) {
            return new PTBInputStream.TempoHelper(this, n2, n3, n5);
        }
        return null;
    }

    private void readDynamic() {
        this.readUInt();
        this.readByte();
        this.readByte();
        this.readUInt();
    }

    private void readSectionSymbol() {
        this.readUInt();
        this.readByte();
        this.readULong();
    }

    private long readSection(int n, int n2, long l, List list) {
        int n3;
        ArrayList<PTBInputStream.TrackHelper> arrayList = new ArrayList<PTBInputStream.TrackHelper>();
        ArrayList<PTBInputStream.BarHelper> arrayList2 = new ArrayList<PTBInputStream.BarHelper>();
        int n4 = this.readULong();
        int n5 = this.readULong();
        int n6 = this.readULong();
        int n7 = this.readULong();
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        arrayList2.add(this.readBarLine());
        int n8 = this.readHeaderItems();
        for (n3 = 0; n3 < n8; ++n3) {
            this.readDirection();
            if (n3 >= n8 - 1) continue;
            this.readUInt();
        }
        n8 = this.readHeaderItems();
        for (n3 = 0; n3 < n8; ++n3) {
            this.readChordText();
            if (n3 >= n8 - 1) continue;
            this.readUInt();
        }
        n8 = this.readHeaderItems();
        for (n3 = 0; n3 < n8; ++n3) {
            this.readRhythmSlash();
            if (n3 >= n8 - 1) continue;
            this.readUInt();
        }
        n8 = this.readHeaderItems();
        for (n3 = 0; n3 < n8; ++n3) {
            PTBInputStream.TrackHelper trackHelper = new PTBInputStream.TrackHelper(this, n + n3, n2);
            arrayList.add(trackHelper);
            this.readStaff(trackHelper, l);
            if (n3 >= n8 - 1) continue;
            this.readUInt();
        }
        n8 = this.readHeaderItems();
        for (n3 = 0; n3 < n8; ++n3) {
            arrayList2.add(this.readBarLine());
            if (n3 >= n8 - 1) continue;
            this.readUInt();
        }
        return this.makeSectionNotes(l, arrayList, arrayList2, list);
    }

    private void readRehearsalSign() {
        this.readByte();
        this.readString();
    }

    private void readDirection() {
        this.readByte();
        int n = this.readByte();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readUInt();
        }
    }

    private void readChordText() {
        this.readByte();
        int n = this.readUInt();
        this.readByte();
        int n2 = this.readUInt();
        this.readByte();
    }

    private void readRhythmSlash() {
        this.readByte();
        this.readByte();
        int n = this.readULong();
    }

    private void readStaff(PTBInputStream.TrackHelper trackHelper, long l) {
        int n;
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        int n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readPosition(trackHelper.getVoice1());
            if (n >= n2 - 1) continue;
            this.readUInt();
        }
        n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readPosition(trackHelper.getVoice2());
            if (n >= n2 - 1) continue;
            this.readUInt();
        }
    }

    private void readPosition(List list) {
        int n;
        int n2;
        PTBInputStream.BeatHelper beatHelper = new PTBInputStream.BeatHelper(this);
        int n3 = this.readByte();
        int n4 = this.readByte();
        n4 = n4 - 128 < 0 ? n4 : n4 - 128;
        this.readByte();
        int n5 = this.readByte();
        int n6 = this.readByte();
        int n7 = this.readByte();
        int n8 = this.readByte();
        int n9 = 1;
        int n10 = this.readByte();
        for (n2 = 0; n2 < n10; ++n2) {
            n = this.readUInt();
            this.readByte();
            int n11 = this.readByte();
            if ((n11 & 8) == 0) continue;
            n9 = n;
        }
        n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readNote(beatHelper);
            if (n >= n2 - 1) continue;
            this.readUInt();
        }
        beatHelper.setPosition(n3);
        beatHelper.setMultiBarRest(n2 == 0 ? n9 : 1);
        beatHelper.setAcciaccatura((n7 & 1) != 0);
        beatHelper.setVibrato((n5 & 8) != 0 || (n5 & 0x10) != 0);
        beatHelper.setDuration(new Duration(n8));
        beatHelper.getDuration().setDotted((n5 & 1) != 0);
        beatHelper.getDuration().setDoubleDotted((n5 & 2) != 0);
        beatHelper.getDuration().getTupleto().setEnters((n4 - n4 % 8) / 8 + 1);
        beatHelper.getDuration().getTupleto().setTimes(n4 % 8 + 1);
        list.add(beatHelper);
    }

    private PTBInputStream.BarHelper readBarLine() {
        PTBInputStream.BarHelper barHelper = new PTBInputStream.BarHelper(this, this.readByte());
        int n = this.readByte();
        barHelper.setRepeatStart(n >>> 5 == 3);
        barHelper.setNumberOfRepetitions(n >>> 5 == 4 ? n - 128 : 0);
        this.readKeySignature();
        barHelper.setTimeSignature(this.readTimeSignature());
        this.readRehearsalSign();
        return barHelper;
    }

    private void readKeySignature() {
        this.readByte();
    }

    private TimeSignature readTimeSignature() {
        int n = this.readULong();
        int n2 = this.readByte();
        return new TimeSignature(((n >> 24) - (n >> 24) % 8) / 8 + 1, new Duration((int)Math.pow(2.0, (n >> 24) % 8)));
    }

    private void readNote(PTBInputStream.BeatHelper beatHelper) {
        int n;
        int n2;
        PTBInputStream.NoteHelper noteHelper = new PTBInputStream.NoteHelper(this);
        int n3 = this.readByte();
        int n4 = this.readUInt();
        int n5 = this.readByte();
        for (n2 = 0; n2 < n5; ++n2) {
            n = this.readByte();
            int n6 = this.readByte();
            int n7 = this.readByte();
            int n8 = this.readByte();
            noteHelper.setBend(n8 == 101 ? n7 / 16 + 1 : 0);
            noteHelper.setSlide(n8 == 100);
        }
        noteHelper.setValue(n3 & 0x1F);
        noteHelper.setString(((n3 & 0xE0) >> 5) + 1);
        noteHelper.setTied((n4 & 1) != 0);
        noteHelper.setDead((n4 & 2) != 0);
        n2 = (n4 >> 4 & 8) != 0 ? 1 : 0;
        n = (n4 >> 4 & 2) != 0 ? 1 : 0;
        beatHelper.addNote(noteHelper);
    }

    public static void main(String[] stringArray) {
        String string = "/home/julian/test.ptb";
        try {
            new PTB4InputStream(string).readSong();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

