/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.importer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import org.herac.tuxguitar.io.importer.SongImporter;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class MidiImporter
implements SongImporter {
    private static final long MIN_START = 1000L;
    private static final Duration MIN_DURATION = new Duration(64);
    private float divisionType;
    private int resolution;
    private boolean moveTick;
    private List headers;
    private List tracks;
    private List tempNotes;
    private List tempChannels;
    private List trackTunningHelpers;

    public Song importSong(String string) throws IOException, Exception, Error {
        Sequence sequence = MidiSystem.getSequence(new File(string));
        this.initFields(sequence);
        Track[] trackArray = sequence.getTracks();
        for (int i = 0; i < trackArray.length; ++i) {
            Track track = trackArray[i];
            int n = this.getNextTrackNumber();
            int n2 = track.size();
            for (int j = 0; j < n2; ++j) {
                MidiEvent midiEvent = track.get(j);
                this.parseMessage(n, midiEvent.getTick(), midiEvent.getMessage().getMessage());
            }
        }
        this.checkAll();
        return new SongAdjuster(new Song(this.tracks, this.headers)).adjustSong();
    }

    private void initFields(Sequence sequence) {
        this.divisionType = sequence.getDivisionType();
        this.resolution = sequence.getResolution();
        this.headers = new ArrayList();
        this.tracks = new ArrayList();
        this.tempNotes = new ArrayList();
        this.tempChannels = new ArrayList();
        this.trackTunningHelpers = new ArrayList();
    }

    private int getNextTrackNumber() {
        return this.tracks.size() + 1;
    }

    private void parseMessage(int n, long l, byte[] byArray) {
        int n2 = byArray.length;
        l = this.parseTick(l + (long)this.resolution);
        if (((n2 > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 144) {
            this.parseNoteOn(n, l, byArray);
        } else if (((n2 > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 128) {
            this.parseNoteOff(n, l, byArray);
        } else if (((n2 > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 192) {
            this.parseProgramChange(byArray);
        } else if (((n2 > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 176) {
            this.parseControlChange(byArray);
        } else if ((n2 > 0 ? byArray[0] & 0xFF : 0) == 255 && byArray[1] == 88) {
            this.parseTimeSignature(l, byArray);
        } else if ((n2 > 0 ? byArray[0] & 0xFF : 0) == 255 && byArray[1] == 81) {
            this.parseTempo(l, byArray);
        }
    }

    private long parseTick(long l) {
        return Math.abs(1000L * l / (long)this.resolution);
    }

    private void parseNoteOn(int n, long l, byte[] byArray) {
        int n2;
        int n3 = byArray.length;
        int n4 = n3 > 0 ? byArray[0] & 0xFF & 0xF : 0;
        int n5 = n3 > 1 ? byArray[1] & 0xFF : 0;
        int n6 = n2 = n3 > 2 ? byArray[2] & 0xFF : 0;
        if (n2 == 0) {
            this.parseNoteOff(n, l, byArray);
        } else if (n5 > 0) {
            this.makeTempNotesBefore(l, n);
            this.getTempChannel(n4).track = n;
            this.getTrackTunningHelper(n).checkValue(n5);
            this.tempNotes.add(new TempNote(n, n4, n5, l));
        }
    }

    private void parseNoteOff(int n, long l, byte[] byArray) {
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : 0;
        int n4 = n2 > 1 ? byArray[1] & 0xFF : 0;
        int n5 = n2 > 2 ? byArray[2] & 0xFF : 0;
        this.makeNote(l, n, n3, n4);
    }

    private void parseProgramChange(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n = n2 > 1 ? byArray[1] & 0xFF : -1;
        if (n3 != -1 && n != -1) {
            this.getTempChannel(n3).instrument = n;
        }
    }

    private void parseControlChange(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n2 > 1 ? byArray[1] & 0xFF : -1;
        int n5 = n = n2 > 2 ? byArray[2] & 0xFF : -1;
        if (n3 != -1 && n4 != -1 && n != -1) {
            if (n4 == 7) {
                this.getTempChannel(n3).volume = n;
            } else if (n4 == 10) {
                this.getTempChannel(n3).balance = n;
            }
        }
    }

    private void parseTimeSignature(long l, byte[] byArray) {
        TimeSignature timeSignature = new TimeSignature(byArray[3], new Duration(4));
        if (byArray[4] == 0) {
            timeSignature.getDenominator().setValue(1);
        } else if (byArray[4] == 1) {
            timeSignature.getDenominator().setValue(2);
        } else if (byArray[4] == 2) {
            timeSignature.getDenominator().setValue(4);
        } else if (byArray[4] == 3) {
            timeSignature.getDenominator().setValue(8);
        } else if (byArray[4] == 4) {
            timeSignature.getDenominator().setValue(16);
        } else if (byArray[4] == 5) {
            timeSignature.getDenominator().setValue(32);
        }
        this.getHeader(l).setTimeSignature(timeSignature);
    }

    private void parseTempo(long l, byte[] byArray) {
        Tempo tempo = Tempo.fromUSQ(byArray[5] & 0xFF | (byArray[4] & 0xFF) << 8 | (byArray[3] & 0xFF) << 16);
        this.getHeader(l).setTempo(tempo);
    }

    private SongTrack getTrack(int n) {
        Object object2;
        for (Object object2 : this.tracks) {
            if (((SongTrack)object2).getNumber() != n) continue;
            return object2;
        }
        object2 = new SongChannel(-1, -1, 0);
        SongTrack songTrack = new SongTrack(n, "", (SongChannel)object2, new ArrayList(), new ArrayList(), 0, (RGBColor)RGBColor.RED.clone());
        this.tracks.add(songTrack);
        return songTrack;
    }

    private MeasureHeader getHeader(long l) {
        MeasureHeader measureHeader2;
        l = l >= 1000L ? l : 1000L;
        for (MeasureHeader measureHeader2 : this.headers) {
            if (l < measureHeader2.getStart() || l >= measureHeader2.getStart() + measureHeader2.getLength()) continue;
            return measureHeader2;
        }
        measureHeader2 = this.getLastHeader();
        int n = measureHeader2 != null ? measureHeader2.getNumber() + 1 : 1;
        long l2 = measureHeader2 != null ? measureHeader2.getStart() + measureHeader2.getLength() : 1000L;
        int n2 = 1;
        TimeSignature timeSignature = measureHeader2 != null ? (TimeSignature)measureHeader2.getTimeSignature().clone() : new TimeSignature(4, new Duration(4));
        Tempo tempo = measureHeader2 != null ? (Tempo)measureHeader2.getTempo().clone() : new Tempo(120);
        MeasureHeader measureHeader3 = new MeasureHeader(n, l2, timeSignature, tempo, null, n2, false, 0);
        this.headers.add(measureHeader3);
        if (measureHeader3.getStart() + measureHeader3.getLength() <= l) {
            return measureHeader3;
        }
        return this.getHeader(l);
    }

    private MeasureHeader getLastHeader() {
        if (!this.headers.isEmpty()) {
            return (MeasureHeader)this.headers.get(this.headers.size() - 1);
        }
        return null;
    }

    private Measure getMeasure(SongTrack songTrack, long l) {
        l = l >= 1000L ? l : 1000L;
        for (Measure measure : songTrack.getMeasures()) {
            if (l < measure.getStart() || l >= measure.getStart() + measure.getLength()) continue;
            return measure;
        }
        this.getHeader(l);
        for (int i = 0; i < this.headers.size(); ++i) {
            boolean bl = false;
            MeasureHeader measureHeader = (MeasureHeader)this.headers.get(i);
            for (int j = 0; j < songTrack.getMeasures().size(); ++j) {
                Measure measure = (Measure)songTrack.getMeasures().get(j);
                if (!measure.getHeader().equals(measureHeader)) continue;
                bl = true;
            }
            if (bl) continue;
            songTrack.getMeasures().add(new Measure(measureHeader, new ArrayList(), new ArrayList(), 1, 0));
        }
        return this.getMeasure(songTrack, l);
    }

    private TempNote getTempNote(int n, int n2, int n3, boolean bl) {
        for (int i = 0; i < this.tempNotes.size(); ++i) {
            TempNote tempNote = (TempNote)this.tempNotes.get(i);
            if (tempNote.track != n || tempNote.channel != n2 || tempNote.value != n3) continue;
            if (bl) {
                this.tempNotes.remove(i);
            }
            return tempNote;
        }
        return null;
    }

    private TrackTunningHelper getTrackTunningHelper(int n) {
        TrackTunningHelper trackTunningHelper2;
        for (TrackTunningHelper trackTunningHelper2 : this.trackTunningHelpers) {
            if (trackTunningHelper2.getTrack() != n) continue;
            return trackTunningHelper2;
        }
        trackTunningHelper2 = new TrackTunningHelper(n);
        this.trackTunningHelpers.add(trackTunningHelper2);
        return trackTunningHelper2;
    }

    private void makeTempNotesBefore(long l, int n) {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            for (int i = 0; i < this.tempNotes.size(); ++i) {
                TempNote tempNote = (TempNote)this.tempNotes.get(i);
                if (tempNote.tick >= l || tempNote.track != n) continue;
                l = tempNote.tick + 5000L;
                this.makeNote(l, n, tempNote.channel, tempNote.value);
                bl = true;
                continue block0;
            }
        }
    }

    private void makeNote(long l, int n, int n2, int n3) {
        TempNote tempNote = this.getTempNote(n, n2, n3, true);
        if (tempNote != null) {
            int n4 = 0;
            int n5 = tempNote.value;
            int n6 = 64;
            long l2 = tempNote.tick;
            Duration duration = Duration.fromTime(l - tempNote.tick, MIN_DURATION);
            NoteEffect noteEffect = new NoteEffect();
            Measure measure = this.getMeasure(this.getTrack(n), tempNote.tick);
            Note note = new Note(n5, l2, duration, n6, n4, false, noteEffect);
            measure.addNote(note);
        }
    }

    public TempChannel getTempChannel(int n) {
        TempChannel tempChannel2;
        for (TempChannel tempChannel2 : this.tempChannels) {
            if (tempChannel2.channel != n) continue;
            return tempChannel2;
        }
        tempChannel2 = new TempChannel(n);
        this.tempChannels.add(tempChannel2);
        return tempChannel2;
    }

    private void checkAll() throws Exception {
        this.checkTracks();
        int n = this.headers.size();
        for (int i = 0; i < this.tracks.size(); ++i) {
            SongTrack songTrack = (SongTrack)this.tracks.get(i);
            while (songTrack.getMeasures().size() < n) {
                long l = 1000L;
                Measure measure = !songTrack.getMeasures().isEmpty() ? songTrack.getMeasures().get(songTrack.getMeasures().size() - 1) : null;
                if (measure != null) {
                    l = measure.getStart() + measure.getLength();
                }
                songTrack.getMeasures().add(new Measure(this.getHeader(l), new ArrayList(), new ArrayList(), 1, 0));
            }
        }
        if (this.headers.isEmpty() || this.tracks.isEmpty()) {
            throw new Exception("Empty Song");
        }
    }

    private void checkTracks() {
        for (SongTrack songTrack : this.tracks) {
            boolean bl = false;
            boolean bl2 = false;
            for (TempChannel tempChannel : this.tempChannels) {
                if (tempChannel.track != songTrack.getNumber()) continue;
                if (songTrack.getChannel().getChannel() < 0) {
                    songTrack.getChannel().setChannel((short)tempChannel.channel);
                    songTrack.getChannel().setInstrument((short)tempChannel.instrument);
                    songTrack.getChannel().setVolume((short)tempChannel.volume);
                    songTrack.getChannel().setBalance((short)tempChannel.balance);
                    continue;
                }
                if (songTrack.getChannel().getEffectChannel() >= 0) continue;
                songTrack.getChannel().setEffectChannel((short)tempChannel.channel);
            }
            if (songTrack.getChannel().getChannel() < 0) {
                songTrack.getChannel().setChannel((short)15);
                songTrack.getChannel().setInstrument((short)0);
                songTrack.getChannel().setVolume((short)127);
                songTrack.getChannel().setBalance((short)64);
            }
            if (songTrack.getChannel().getEffectChannel() < 0) {
                songTrack.getChannel().setEffectChannel(songTrack.getChannel().getChannel());
            }
            if (!songTrack.isPercussionTrack()) {
                songTrack.setStrings(this.getTrackTunningHelper(songTrack.getNumber()).getStrings());
                continue;
            }
            songTrack.setStrings(SongManager.createPercusionStrings(6));
        }
    }

    private class SongAdjuster {
        private Song song;
        private long minDurationTime;

        public SongAdjuster(Song song) {
            this.song = song;
            this.minDurationTime = 60L;
        }

        public Song adjustSong() {
            for (SongTrack songTrack : this.song.getTracks()) {
                this.adjustTrack(songTrack);
            }
            return this.song;
        }

        private void adjustTrack(SongTrack songTrack) {
            for (Measure measure : songTrack.getMeasures()) {
                this.adjustMeasure(measure);
                this.adjustStrings(songTrack, measure);
            }
        }

        private void adjustMeasure(Measure measure) {
            ArrayList<Note> arrayList = new ArrayList<Note>();
            long l = measure.getStart();
            for (int i = 0; i < measure.getNotes().size(); ++i) {
                Note note = (Note)measure.getNotes().get(i);
                long l2 = note.getStart();
                int n = i + 1;
                arrayList.add(note);
                if (l < l2 && l + this.minDurationTime > l2 || l > l2 && l - this.minDurationTime < l2) {
                    note.setStart(l);
                }
                long l3 = measure.getStart() + measure.getLength();
                int n2 = n;
                while (n2 < measure.getNotes().size()) {
                    Note note2 = (Note)measure.getNotes().get(n2);
                    long l4 = note2.getDuration().getTime();
                    long l5 = 0L;
                    if (l2 + this.minDurationTime <= note2.getStart()) {
                        l3 = note2.getStart();
                        break;
                    }
                    l2 = note2.getStart() > l2 ? note2.getStart() : l2;
                    arrayList.add(note2);
                    i = n2++;
                }
                l += this.adjustBeat(arrayList, note.getStart(), l3);
                arrayList.clear();
            }
        }

        private long adjustBeat(List list, long l, long l2) {
            Note note;
            int n;
            Duration duration = Duration.fromTime(l2 - l, MIN_DURATION);
            long l3 = duration.getTime();
            Duration duration2 = null;
            for (n = 0; n < list.size(); ++n) {
                note = (Note)list.get(n);
                note.setStart(l);
                if (duration2 != null && note.getDuration().getTime() <= duration2.getTime()) continue;
                duration2 = note.getDuration();
            }
            if (duration2 != null) {
                if (duration2.getTime() > l3) {
                    duration2 = duration;
                }
                for (n = 0; n < list.size(); ++n) {
                    note = (Note)list.get(n);
                    note.setStart(l);
                    note.setDuration((Duration)duration2.clone());
                }
            }
            return l3;
        }

        private void adjustStrings(SongTrack songTrack, Measure measure) {
            ArrayList arrayList = new ArrayList();
            long l = 0L;
            for (Note note : measure.getNotes()) {
                if (note.getStart() != l) {
                    arrayList.clear();
                    arrayList.addAll(songTrack.getStrings());
                }
                int n = this.getStringForValue(arrayList, note.getValue());
                for (int i = 0; i < arrayList.size(); ++i) {
                    InstrumentString instrumentString = (InstrumentString)arrayList.get(i);
                    if (instrumentString.getNumber() != n) continue;
                    note.setValue(note.getValue() - instrumentString.getValue());
                    note.setString(instrumentString.getNumber());
                    arrayList.remove(i);
                    break;
                }
                if (note.getString() < 1) {
                    n = this.getStringForValue(songTrack.getStrings(), note.getValue());
                    note.setValue(note.getValue() - ((InstrumentString)songTrack.getStrings().get(n - 1)).getValue());
                    note.setString(n);
                }
                l = note.getStart();
            }
        }

        private int getStringForValue(List list, int n) {
            int n2 = -1;
            int n3 = 0;
            for (int i = 0; i < list.size(); ++i) {
                InstrumentString instrumentString = (InstrumentString)list.get(i);
                int n4 = n - instrumentString.getValue();
                if (n2 >= 0 && (n4 < 0 || n4 >= n2)) continue;
                n3 = instrumentString.getNumber();
                n2 = n4;
            }
            return n3;
        }
    }

    private class TrackTunningHelper {
        private int track;
        private int maxValue;
        private int minValue;

        public TrackTunningHelper(int n) {
            this.track = n;
            this.maxValue = -1;
            this.minValue = -1;
        }

        public void checkValue(int n) {
            if (this.minValue < 0 || n < this.minValue) {
                this.minValue = n;
            }
            if (this.maxValue < 0 || n > this.maxValue) {
                this.maxValue = n;
            }
        }

        private List getStrings() {
            ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
            int n = 24;
            if (this.minValue >= 40 && this.maxValue <= 64 + n) {
                arrayList.add(new InstrumentString(1, 64));
                arrayList.add(new InstrumentString(2, 59));
                arrayList.add(new InstrumentString(3, 55));
                arrayList.add(new InstrumentString(4, 50));
                arrayList.add(new InstrumentString(5, 45));
                arrayList.add(new InstrumentString(6, 40));
            } else if (this.minValue >= 38 && this.maxValue <= 64 + n) {
                arrayList.add(new InstrumentString(1, 64));
                arrayList.add(new InstrumentString(2, 59));
                arrayList.add(new InstrumentString(3, 55));
                arrayList.add(new InstrumentString(4, 50));
                arrayList.add(new InstrumentString(5, 45));
                arrayList.add(new InstrumentString(6, 38));
            } else if (this.minValue >= 35 && this.maxValue <= 64 + n) {
                arrayList.add(new InstrumentString(1, 64));
                arrayList.add(new InstrumentString(2, 59));
                arrayList.add(new InstrumentString(3, 55));
                arrayList.add(new InstrumentString(4, 50));
                arrayList.add(new InstrumentString(5, 45));
                arrayList.add(new InstrumentString(6, 40));
                arrayList.add(new InstrumentString(7, 35));
            } else if (this.minValue >= 28 && this.maxValue <= 43 + n) {
                arrayList.add(new InstrumentString(1, 43));
                arrayList.add(new InstrumentString(2, 38));
                arrayList.add(new InstrumentString(3, 33));
                arrayList.add(new InstrumentString(4, 28));
            } else if (this.minValue >= 23 && this.maxValue <= 43 + n) {
                arrayList.add(new InstrumentString(1, 43));
                arrayList.add(new InstrumentString(2, 38));
                arrayList.add(new InstrumentString(3, 33));
                arrayList.add(new InstrumentString(4, 28));
                arrayList.add(new InstrumentString(5, 23));
            } else {
                int n2 = 6;
                int n3 = (this.maxValue - (n - 4) - this.minValue) / n2;
                if (n3 > 5) {
                    n2 = 7;
                    n3 = (this.maxValue - (n - 4) - this.minValue) / n2;
                }
                int n4 = this.minValue + n2 * n3;
                while (arrayList.size() < n2) {
                    arrayList.add(new InstrumentString(arrayList.size() + 1, n4 -= n3));
                }
            }
            return arrayList;
        }

        public int getMaxValue() {
            return this.maxValue;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public int getTrack() {
            return this.track;
        }
    }

    private class TempChannel {
        private int channel;
        private int instrument;
        private int volume;
        private int balance;
        private int track;

        public TempChannel(int n) {
            this.channel = n;
            this.instrument = 0;
            this.volume = 127;
            this.balance = 64;
            this.track = -1;
        }
    }

    private class TempNote {
        private int track;
        private int channel;
        private int value;
        private long tick;

        public TempNote(int n, int n2, int n3, long l) {
            this.track = n;
            this.channel = n2;
            this.value = n3;
            this.tick = l;
        }
    }
}

