/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintPage;
import org.herac.tuxguitar.gui.util.ImageUtils;

public class PDFWriter {
    public static void write(String string, PrintDocument printDocument) {
        try {
            PDFWriter.write(new FileOutputStream(string), printDocument);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public static void write(OutputStream outputStream, PrintDocument printDocument) {
        Document document = new Document();
        try {
            PdfWriter.getInstance(document, outputStream);
            document.open();
            for (PrintPage printPage : printDocument.getPages()) {
                document.newPage();
                document.add(ImageUtils.convertToIText(printPage.getData()));
            }
        }
        catch (DocumentException documentException) {
            System.err.println(documentException.getMessage());
        }
        document.close();
    }
}

