/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;

public class FileChooser {
    public static FilterFormat OPEN_FORMAT;
    public static FilterFormat IMPORT_MIDI_FORMAT;
    public static FilterFormat SAVE_FORMAT;
    public static FilterFormat EXPORT_MIDI_FORMAT;
    public static FilterFormat EXPORT_PDF_FORMAT;
    public static FilterFormat EXPORT_ASCII_FORMAT;
    public static FilterFormat ALL_FORMAT;
    private static FileChooser instance;

    public static FileChooser instance() {
        if (instance == null) {
            instance = new FileChooser();
        }
        return instance;
    }

    public String open(Shell shell, FilterFormat filterFormat) {
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setFilterPath(this.getPath());
        fileDialog.setFileName(this.getFileName(filterFormat));
        fileDialog.setFilterNames(filterFormat.filterNames);
        fileDialog.setFilterExtensions(filterFormat.filterExtensions);
        return fileDialog.open();
    }

    public String save(Shell shell, FilterFormat filterFormat) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFilterPath(this.getPath());
        fileDialog.setFileName(this.getFileName(filterFormat));
        fileDialog.setFilterNames(filterFormat.filterNames);
        fileDialog.setFilterExtensions(filterFormat.filterExtensions);
        return fileDialog.open();
    }

    private String getPath() {
        return TuxGuitar.instance().getFileHistory().getFilePath();
    }

    private String getFileName(FilterFormat filterFormat) {
        int n;
        if (filterFormat == null || filterFormat.filterExtensions == null) {
            return null;
        }
        String string = TuxGuitar.instance().getFileHistory().getFileName();
        for (n = 0; n < filterFormat.filterExtensions.length; ++n) {
            String string2 = string.substring(string.lastIndexOf(46)).toLowerCase();
            int n2 = filterFormat.filterExtensions[n].indexOf(string2);
            int n3 = string2.length() + n2;
            if (n2 <= 0 || n3 != filterFormat.filterExtensions[n].length() && filterFormat.filterExtensions[n].charAt(n3) != ';') continue;
            return string;
        }
        if (filterFormat.filterExtensions.length > 0 && string.lastIndexOf(46) > 0) {
            n = string.lastIndexOf(46);
            return string.substring(0, string.lastIndexOf(46)) + filterFormat.filterExtensions[0].substring(filterFormat.filterExtensions[0].lastIndexOf(46));
        }
        return null;
    }

    static {
        FileChooser fileChooser = FileChooser.instance();
        fileChooser.getClass();
        OPEN_FORMAT = fileChooser.new FilterFormat(new String[]{"*.tg;*.gp3;*.gp4;*.gp5;*.ptb"}, new String[]{"Suported Files (*.tg,*.gp3,*.gp4,*.gp5,*.ptb)"});
        FileChooser fileChooser2 = FileChooser.instance();
        fileChooser2.getClass();
        IMPORT_MIDI_FORMAT = fileChooser2.new FilterFormat(new String[]{"*.mid"}, new String[]{"Suported Files (*.mid)"});
        FileChooser fileChooser3 = FileChooser.instance();
        fileChooser3.getClass();
        SAVE_FORMAT = fileChooser3.new FilterFormat(new String[]{"*.gp4", "*.gp3", "*.tg"}, null);
        FileChooser fileChooser4 = FileChooser.instance();
        fileChooser4.getClass();
        EXPORT_MIDI_FORMAT = fileChooser4.new FilterFormat(new String[]{"*.mid"}, null);
        FileChooser fileChooser5 = FileChooser.instance();
        fileChooser5.getClass();
        EXPORT_PDF_FORMAT = fileChooser5.new FilterFormat(new String[]{"*.pdf"}, null);
        FileChooser fileChooser6 = FileChooser.instance();
        fileChooser6.getClass();
        EXPORT_ASCII_FORMAT = fileChooser6.new FilterFormat(new String[]{"*.tab"}, null);
        FileChooser fileChooser7 = FileChooser.instance();
        fileChooser7.getClass();
        ALL_FORMAT = fileChooser7.new FilterFormat(null, null);
    }

    private class FilterFormat {
        private String[] filterExtensions;
        private String[] filterNames;

        private FilterFormat(String[] stringArray, String[] stringArray2) {
            this.filterExtensions = stringArray;
            this.filterNames = stringArray2;
        }
    }
}

