/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableTrackGeneric
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private UndoTrack undoTrack;
    private RedoTrack redoTrack;

    private UndoableTrackGeneric() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.redoTrack.redo();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.undoTrack.undo();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableTrackGeneric startUndo(SongTrack songTrack) {
        Caret caret = UndoableTrackGeneric.getCaret();
        UndoableTrackGeneric undoableTrackGeneric = new UndoableTrackGeneric();
        undoableTrackGeneric.doAction = 1;
        undoableTrackGeneric.undoCaret = new UndoableCaretHelper();
        UndoableTrackGeneric undoableTrackGeneric2 = undoableTrackGeneric;
        undoableTrackGeneric2.getClass();
        undoableTrackGeneric.undoTrack = undoableTrackGeneric2.new UndoTrack(songTrack);
        return undoableTrackGeneric;
    }

    public UndoableTrackGeneric endUndo(SongTrack songTrack) {
        Caret caret = UndoableTrackGeneric.getCaret();
        this.redoCaret = new UndoableCaretHelper();
        this.redoTrack = new RedoTrack(songTrack);
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private class RedoTrack {
        private SongTrack track;

        public RedoTrack(SongTrack songTrack) {
            if (songTrack != null) {
                this.track = (SongTrack)songTrack.clone(TuxGuitar.instance().getSongManager().getMeasureHeaders());
            }
        }

        public void redo() {
            if (this.track != null) {
                TuxGuitar.instance().getSongManager().replaceTrack(this.track);
                TuxGuitar.instance().fireUpdate();
                TuxGuitar.instance().getMixer().update();
            }
        }
    }

    private class UndoTrack {
        private SongTrack track;

        public UndoTrack(SongTrack songTrack) {
            if (songTrack != null) {
                this.track = (SongTrack)songTrack.clone(TuxGuitar.instance().getSongManager().getMeasureHeaders());
            }
        }

        public void undo() {
            if (this.track != null) {
                TuxGuitar.instance().getSongManager().replaceTrack(this.track);
                TuxGuitar.instance().fireUpdate();
                TuxGuitar.instance().getMixer().update();
            }
        }
    }
}

