/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableInstrumentTrack
implements UndoableEdit {
    private int doAction;
    private int trackNumber;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private short undoInstrument;
    private short redoInstrument;
    private boolean undoPercusion;
    private boolean redoPercusion;

    private UndoableInstrumentTrack() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.getTrackManager().changeInstrument(songManager.getTrack(this.trackNumber), this.redoInstrument, this.redoPercusion);
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updatePrograms();
        }
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.getTrackManager().changeInstrument(songManager.getTrack(this.trackNumber), this.undoInstrument, this.undoPercusion);
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updatePrograms();
        }
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableInstrumentTrack startUndo(SongTrack songTrack) {
        UndoableInstrumentTrack undoableInstrumentTrack = new UndoableInstrumentTrack();
        Caret caret = UndoableInstrumentTrack.getCaret();
        undoableInstrumentTrack.doAction = 1;
        undoableInstrumentTrack.undoCaret = new UndoableCaretHelper();
        undoableInstrumentTrack.trackNumber = songTrack.getNumber();
        undoableInstrumentTrack.undoInstrument = songTrack.getChannel().getInstrument();
        undoableInstrumentTrack.undoPercusion = songTrack.isPercussionTrack();
        return undoableInstrumentTrack;
    }

    public UndoableInstrumentTrack endUndo(SongTrack songTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoInstrument = songTrack.getChannel().getInstrument();
        this.redoPercusion = songTrack.isPercussionTrack();
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

