/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;

public class UndoableCloneTrack
implements UndoableEdit {
    private int doAction;
    private int trackNumber;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;

    private UndoableCloneTrack() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().cloneTrack(TuxGuitar.instance().getSongManager().getTrack(this.trackNumber));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TuxGuitar.instance().getSongManager().removeTrack(TuxGuitar.instance().getSongManager().getLastTrack());
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableCloneTrack startUndo() {
        UndoableCloneTrack undoableCloneTrack = new UndoableCloneTrack();
        Caret caret = UndoableCloneTrack.getCaret();
        undoableCloneTrack.doAction = 1;
        undoableCloneTrack.undoCaret = new UndoableCaretHelper();
        undoableCloneTrack.trackNumber = caret.getSongTrackCoords().getTrack().getNumber();
        return undoableCloneTrack;
    }

    public UndoableCloneTrack endUndo() {
        this.redoCaret = new UndoableCaretHelper();
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

