/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;

public class UndoableMeasureGeneric
implements UndoableEdit {
    private int doAction;
    private int trackNumber;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private Measure undoMeasure;
    private Measure redoMeasure;

    private UndoableMeasureGeneric() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.replace(this.redoMeasure);
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.replace(this.undoMeasure);
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    private void replace(Measure measure) {
        SongTrackCoords songTrackCoords = UndoableMeasureGeneric.getCaret().getSongCoords().getTrack(this.trackNumber);
        if (songTrackCoords != null && measure != null) {
            MeasureHeader measureHeader = TuxGuitar.instance().getSongManager().getMeasureHeader(measure.getNumber());
            Measure measure2 = (Measure)measure.clone(measureHeader);
            measure2 = TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(songTrackCoords.getTrack(), measure2);
            TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure2.getNumber(), false);
        }
    }

    public static UndoableMeasureGeneric startUndo() {
        UndoableMeasureGeneric undoableMeasureGeneric = new UndoableMeasureGeneric();
        Caret caret = UndoableMeasureGeneric.getCaret();
        undoableMeasureGeneric.doAction = 1;
        undoableMeasureGeneric.trackNumber = caret.getSongTrackCoords().getTrack().getNumber();
        undoableMeasureGeneric.undoCaret = new UndoableCaretHelper();
        undoableMeasureGeneric.undoMeasure = (Measure)caret.getMeasureCoords().getMeasure().clone((MeasureHeader)caret.getMeasureCoords().getMeasure().getHeader().clone());
        return undoableMeasureGeneric;
    }

    public UndoableMeasureGeneric endUndo() {
        Caret caret = UndoableMeasureGeneric.getCaret();
        this.redoCaret = new UndoableCaretHelper();
        this.redoMeasure = (Measure)caret.getMeasureCoords().getMeasure().clone((MeasureHeader)caret.getMeasureCoords().getMeasure().getHeader().clone());
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

