/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.helpers.TracksMeasures;

public class UndoableInsertMeasure
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private TracksMeasures tracksMeasures;
    private long insertPosition;
    private int copyCount;
    private int fromNumber;
    private long theMove;

    public UndoableInsertMeasure() {
        Caret caret = UndoableInsertMeasure.getCaret();
        this.doAction = 1;
        this.undoCaret = new UndoableCaretHelper();
        this.insertPosition = caret.getPosition();
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().insertMeasures((TracksMeasures)this.tracksMeasures.clone(), this.fromNumber, this.theMove);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        for (int i = 0; i < this.copyCount; ++i) {
            TuxGuitar.instance().getSongManager().removeMeasure(this.insertPosition);
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public UndoableInsertMeasure endUndo(TracksMeasures tracksMeasures, int n, int n2, long l) {
        this.redoCaret = new UndoableCaretHelper();
        this.copyCount = n;
        this.tracksMeasures = tracksMeasures;
        this.fromNumber = n2;
        this.theMove = l;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

