/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;

public class UndoableChangeTripletFeel
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long position;
    private int redoableTripletFeel;
    private int undoableTripletFeel;
    private List nextTripletFeelPositions;
    private boolean toEnd;

    private UndoableChangeTripletFeel() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().changeTripletFeel(this.position, this.redoableTripletFeel, this.toEnd);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        SongCoords songCoords = UndoableChangeTripletFeel.getCaret().getSongCoords();
        TuxGuitar.instance().getSongManager().changeTripletFeel(this.position, this.undoableTripletFeel, this.toEnd);
        if (this.toEnd) {
            for (TripletFeelPosition tripletFeelPosition : this.nextTripletFeelPositions) {
                TuxGuitar.instance().getSongManager().changeTripletFeel(tripletFeelPosition.getPosition(), tripletFeelPosition.getTripletFeel(), true);
            }
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeTripletFeel startUndo() {
        UndoableChangeTripletFeel undoableChangeTripletFeel = new UndoableChangeTripletFeel();
        Caret caret = UndoableChangeTripletFeel.getCaret();
        undoableChangeTripletFeel.doAction = 1;
        undoableChangeTripletFeel.undoCaret = new UndoableCaretHelper();
        undoableChangeTripletFeel.position = caret.getPosition();
        undoableChangeTripletFeel.undoableTripletFeel = caret.getMeasureCoords().getMeasure().getTripletFeel();
        undoableChangeTripletFeel.nextTripletFeelPositions = new ArrayList();
        int n = undoableChangeTripletFeel.undoableTripletFeel;
        for (MeasureCoords measureCoords : caret.getSongCoords().getFirstTrack().getMeasuresCoords()) {
            if (measureCoords.getMeasure().getStart() <= undoableChangeTripletFeel.position) continue;
            int n2 = measureCoords.getMeasure().getTripletFeel();
            if (n != n2) {
                UndoableChangeTripletFeel undoableChangeTripletFeel2 = undoableChangeTripletFeel;
                undoableChangeTripletFeel2.getClass();
                TripletFeelPosition tripletFeelPosition = undoableChangeTripletFeel2.new TripletFeelPosition(measureCoords.getMeasure().getStart(), n2);
                undoableChangeTripletFeel.nextTripletFeelPositions.add(tripletFeelPosition);
            }
            n = n2;
        }
        return undoableChangeTripletFeel;
    }

    public UndoableChangeTripletFeel endUndo(int n, boolean bl) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoableTripletFeel = n;
        this.toEnd = bl;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private class TripletFeelPosition {
        private long position;
        private int tripletFeel;

        public TripletFeelPosition(long l, int n) {
            this.position = l;
            this.tripletFeel = n;
        }

        public long getPosition() {
            return this.position;
        }

        public int getTripletFeel() {
            return this.tripletFeel;
        }
    }
}

