/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Tempo;

public class UndoableChangeTempo
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long position;
    private Tempo undo;
    private Tempo redo;

    private UndoableChangeTempo() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().changeTempo(this.position, (Tempo)this.redo.clone(), true);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TuxGuitar.instance().getSongManager().changeTempo(this.position, (Tempo)this.undo.clone(), true);
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeTempo startUndo() {
        UndoableChangeTempo undoableChangeTempo = new UndoableChangeTempo();
        Caret caret = UndoableChangeTempo.getCaret();
        undoableChangeTempo.doAction = 1;
        undoableChangeTempo.undoCaret = new UndoableCaretHelper();
        undoableChangeTempo.position = caret.getPosition();
        undoableChangeTempo.undo = (Tempo)caret.getMeasureCoords().getMeasure().getTempo().clone();
        return undoableChangeTempo;
    }

    public UndoableChangeTempo endUndo(Tempo tempo) {
        this.redoCaret = new UndoableCaretHelper();
        this.redo = (Tempo)tempo.clone();
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

