/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Marker;

public class UndoableChangeMarker
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private Marker undoMarker;
    private Marker redoMarker;

    private UndoableChangeMarker() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        if (this.redoMarker != null) {
            TuxGuitar.instance().getSongManager().updateMarker((Marker)this.redoMarker.clone());
        } else if (this.undoMarker != null) {
            TuxGuitar.instance().getSongManager().removeMarker((Marker)this.undoMarker.clone());
        }
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        if (this.undoMarker != null) {
            TuxGuitar.instance().getSongManager().updateMarker((Marker)this.undoMarker.clone());
        } else if (this.redoMarker != null) {
            TuxGuitar.instance().getSongManager().removeMarker((Marker)this.redoMarker.clone());
        }
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeMarker startUndo(Marker marker) {
        Caret caret = UndoableChangeMarker.getCaret();
        UndoableChangeMarker undoableChangeMarker = new UndoableChangeMarker();
        undoableChangeMarker.doAction = 1;
        undoableChangeMarker.undoCaret = new UndoableCaretHelper();
        undoableChangeMarker.undoMarker = marker == null ? null : (Marker)marker.clone();
        return undoableChangeMarker;
    }

    public UndoableChangeMarker endUndo(Marker marker) {
        Caret caret = UndoableChangeMarker.getCaret();
        this.redoCaret = new UndoableCaretHelper();
        this.redoMarker = marker == null ? null : (Marker)marker.clone();
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

