/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableChangeCloseRepeat
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long position;
    private int undoNumberOfRepetitions;
    private int redoNumberOfRepetitions;

    private UndoableChangeCloseRepeat() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.changeCloseRepeat(this.position, this.redoNumberOfRepetitions);
        Measure measure = songManager.getTrackManager().getMeasureAt(songManager.getFirstTrack(), this.position);
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(), false);
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.changeCloseRepeat(this.position, this.undoNumberOfRepetitions);
        Measure measure = songManager.getTrackManager().getMeasureAt(songManager.getFirstTrack(), this.position);
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(), false);
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeCloseRepeat startUndo() {
        UndoableChangeCloseRepeat undoableChangeCloseRepeat = new UndoableChangeCloseRepeat();
        Caret caret = UndoableChangeCloseRepeat.getCaret();
        undoableChangeCloseRepeat.doAction = 1;
        undoableChangeCloseRepeat.undoCaret = new UndoableCaretHelper();
        undoableChangeCloseRepeat.position = caret.getPosition();
        undoableChangeCloseRepeat.undoNumberOfRepetitions = caret.getMeasureCoords().getMeasure().getNumberOfRepetitions();
        return undoableChangeCloseRepeat;
    }

    public UndoableChangeCloseRepeat endUndo(int n) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoNumberOfRepetitions = n;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

