/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;

public class UndoableCaretHelper {
    private long position;
    private int track;
    private int string;
    private int velocity;
    private Duration duration;

    public UndoableCaretHelper() {
        Caret caret = UndoableCaretHelper.getCaret();
        this.track = caret.getSongTrackCoords().getTrack().getNumber();
        this.position = caret.getPosition();
        this.velocity = caret.getVelocity();
        this.duration = (Duration)caret.getDuration().clone();
        this.string = 1;
        InstrumentString instrumentString = caret.getSelectedString();
        if (instrumentString != null) {
            this.string = instrumentString.getNumber();
        }
    }

    public void update() {
        UndoableCaretHelper.getCaret().update(this.track, this.position, this.string, this.velocity);
        UndoableCaretHelper.getCaret().setSelectedDuration((Duration)this.duration.clone());
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

