/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.transport;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.MeasureHeader;

public class SongTransport {
    public static final int STATUS_STOPED = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_RUNNING = 3;
    private Shell dialog;
    private Label label;
    private Scale tickScale;
    private ToolItem first;
    private ToolItem last;
    private ToolItem previous;
    private ToolItem next;
    private ToolItem stop;
    private ToolItem play;
    private boolean editingTickScale;
    private int status;

    public void show() {
        Shell shell = TuxGuitar.instance().getTablatureEditor().getTablature().getShell();
        this.dialog = new Shell(shell, 2144);
        this.dialog.setLayout(new GridLayout());
        this.init();
        this.dialog.pack();
        this.dialog.open();
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
        TuxGuitar.instance().updateCache(true);
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        TuxGuitar.instance().updateCache(true);
    }

    private void init() {
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.initLabel(composite);
        this.initScale(composite);
        this.initButtons(composite);
        this.updateItems();
        this.redraw();
    }

    private void initLabel(Composite composite) {
        this.label = new Label(composite, 133120);
        this.label.setLayoutData(new GridData(4, 4, true, true));
        this.label.setBackground(composite.getDisplay().getSystemColor(2));
        this.label.setForeground(composite.getDisplay().getSystemColor(9));
        this.label.setFont(new Font(composite.getDisplay(), "Minisystem", 36, 0));
    }

    private void initScale(Composite composite) {
        this.tickScale = new Scale(composite, 256);
        this.tickScale.setLayoutData(new GridData(4, 4, true, true));
        this.tickScale.setIncrement(1000);
        this.tickScale.setSelection(1000);
        this.tickScale.addMouseListener(new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                SongTransport.this.setEditingTickScale(true);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if ((long)SongTransport.this.tickScale.getSelection() < 1000L) {
                    SongTransport.this.tickScale.setSelection(1000);
                }
                long l = SongTransport.this.tickScale.getSelection();
                SongTransport.this.gotoMeasure(SongTransport.this.getSongManager().getMeasureHeaderAt(l), true);
                SongTransport.this.redraw();
                SongTransport.this.setEditingTickScale(false);
            }
        });
    }

    private void initButtons(Composite composite) {
        ToolBar toolBar = new ToolBar(this.dialog, 0x800000);
        this.first = new ToolItem(toolBar, 8);
        this.first.setImage(SystemImages.TRANSPORT_FIRST_1);
        this.first.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.gotoFirst(selectionEvent);
            }
        });
        this.previous = new ToolItem(toolBar, 8);
        this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_1);
        this.previous.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.gotoPrevious(selectionEvent);
            }
        });
        this.stop = new ToolItem(toolBar, 8);
        this.stop.setImage(SystemImages.TRANSPORT_STOP_1);
        this.stop.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.stop(selectionEvent);
            }
        });
        this.play = new ToolItem(toolBar, 8);
        this.play.setImage(SystemImages.TRANSPORT_PLAY_1);
        this.play.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.play(selectionEvent);
            }
        });
        this.next = new ToolItem(toolBar, 8);
        this.next.setImage(SystemImages.TRANSPORT_NEXT_1);
        this.next.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.gotoNext(selectionEvent);
            }
        });
        this.last = new ToolItem(toolBar, 8);
        this.last.setImage(SystemImages.TRANSPORT_LAST_1);
        this.last.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SongTransport.this.gotoLast(selectionEvent);
            }
        });
        this.setStatus(1);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void redraw() {
        if (!this.isDisposed()) {
            if (this.isEditingTickScale()) {
                this.label.setText(Long.toString(this.tickScale.getSelection()));
            } else {
                long l = TuxGuitar.instance().getPlayer().getTickPosition();
                this.label.setText(Long.toString(l));
                this.tickScale.setSelection((int)l);
            }
        }
    }

    public void updateItems() {
        if (!this.isDisposed()) {
            int n = this.getStatus();
            if (TuxGuitar.instance().getPlayer().isRunning()) {
                this.setStatus(3);
            } else if (TuxGuitar.instance().getPlayer().isPaused()) {
                this.setStatus(2);
            } else {
                this.setStatus(1);
            }
            if (n != this.getStatus()) {
                if (this.getStatus() == 3) {
                    this.first.setImage(SystemImages.TRANSPORT_FIRST_2);
                    this.last.setImage(SystemImages.TRANSPORT_LAST_2);
                    this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_2);
                    this.next.setImage(SystemImages.TRANSPORT_NEXT_2);
                    this.stop.setImage(SystemImages.TRANSPORT_STOP_2);
                    this.play.setImage(SystemImages.TRANSPORT_PAUSE);
                } else if (this.getStatus() == 2) {
                    this.first.setImage(SystemImages.TRANSPORT_FIRST_2);
                    this.last.setImage(SystemImages.TRANSPORT_LAST_2);
                    this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_2);
                    this.next.setImage(SystemImages.TRANSPORT_NEXT_2);
                    this.stop.setImage(SystemImages.TRANSPORT_STOP_2);
                    this.play.setImage(SystemImages.TRANSPORT_PLAY_2);
                } else if (this.getStatus() == 1) {
                    this.first.setImage(SystemImages.TRANSPORT_FIRST_1);
                    this.last.setImage(SystemImages.TRANSPORT_LAST_1);
                    this.previous.setImage(SystemImages.TRANSPORT_PREVIOUS_1);
                    this.next.setImage(SystemImages.TRANSPORT_NEXT_1);
                    this.stop.setImage(SystemImages.TRANSPORT_STOP_1);
                    this.play.setImage(SystemImages.TRANSPORT_PLAY_1);
                }
            }
            MeasureHeader measureHeader = this.getSongManager().getFirstMeasureHeader();
            MeasureHeader measureHeader2 = this.getSongManager().getLastMeasureHeader();
            this.tickScale.setMinimum((int)measureHeader.getStart());
            this.tickScale.setMaximum((int)(measureHeader2.getStart() + measureHeader2.getLength()) - 1);
            this.tickScale.setPageIncrement((int)((measureHeader2.getStart() + measureHeader2.getLength() - 1000L) / 10L));
            this.redraw();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            // empty if block
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public boolean isEditingTickScale() {
        return this.editingTickScale;
    }

    public void setEditingTickScale(boolean bl) {
        this.editingTickScale = bl;
    }

    private SongManager getSongManager() {
        return TuxGuitar.instance().getSongManager();
    }

    public void gotoFirst(TypedEvent typedEvent) {
        this.gotoMeasure(this.getSongManager().getFirstMeasureHeader(), true);
    }

    public void gotoLast(TypedEvent typedEvent) {
        this.gotoMeasure(this.getSongManager().getLastMeasureHeader(), true);
    }

    public void gotoNext(TypedEvent typedEvent) {
        MidiPlayer midiPlayer = TuxGuitar.instance().getPlayer();
        MeasureHeader measureHeader = this.getSongManager().getMeasureHeaderAt(midiPlayer.getTickPosition());
        if (measureHeader != null) {
            this.gotoMeasure(this.getSongManager().getNextMeasureHeader(measureHeader), true);
        }
    }

    public void gotoPrevious(TypedEvent typedEvent) {
        MidiPlayer midiPlayer = TuxGuitar.instance().getPlayer();
        MeasureHeader measureHeader = this.getSongManager().getMeasureHeaderAt(midiPlayer.getTickPosition());
        if (measureHeader != null) {
            this.gotoMeasure(this.getSongManager().getPrevMeasureHeader(measureHeader), true);
        }
    }

    public void gotoMeasure(MeasureHeader measureHeader) {
        this.gotoMeasure(measureHeader, false);
    }

    private void gotoMeasure(MeasureHeader measureHeader, boolean bl) {
        if (measureHeader != null && !this.getSongManager().isAtPosition(measureHeader, TuxGuitar.instance().getPlayer().getTickPosition())) {
            TuxGuitar.instance().getPlayer().setTickPosition(measureHeader.getStartWidthRepetitions(), measureHeader.getStartWidthRepetitions() - measureHeader.getStart());
            if (bl) {
                TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().goToTickPosition();
                TuxGuitar.instance().redraw();
            }
            this.redraw();
        }
    }

    public void play(TypedEvent typedEvent) {
        TuxGuitar.instance().getAction("action.player.play").process(typedEvent);
    }

    public void stop(TypedEvent typedEvent) {
        TuxGuitar.instance().getAction("action.player.stop").process(typedEvent);
    }
}

