/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.keybindings;

import java.util.StringTokenizer;
import org.herac.tuxguitar.gui.system.keybindings.KeyConversion;

public class KeyBinding {
    public static final String ALT_STRING = "Alt";
    public static final String SHIFT_STRING = "Shift";
    public static final String CONTROL_STRING = "Control";
    public static final String MASK_SEPARATOR = "+";
    private int mask;
    private int key;

    public KeyBinding(int n, int n2) {
        this.key = n;
        this.mask = n2;
    }

    public KeyBinding() {
        this(0, 0);
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int n) {
        this.key = n;
    }

    public int getMask() {
        return this.mask;
    }

    public void setMask(int n) {
        this.mask = n;
    }

    public static KeyBinding parse(String string) {
        String string2 = string;
        KeyBinding keyBinding = new KeyBinding();
        int n = 0;
        if (string.indexOf(MASK_SEPARATOR) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, MASK_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    n |= KeyBinding.getMaskCode(string3);
                    continue;
                }
                string2 = string3;
            }
        }
        keyBinding.setMask(n);
        int n2 = KeyBinding.getSpecialKeyCode(string2);
        if (n2 == 0) {
            n2 = KeyBinding.getKeyCode(string2);
        }
        keyBinding.setKey(n2);
        return keyBinding;
    }

    private static int getKeyCode(String string) {
        return string.charAt(0);
    }

    private static int getSpecialKeyCode(String string) {
        for (int i = 0; i < KeyConversion.relations.length; ++i) {
            if (!string.equals(KeyConversion.relations[i].key)) continue;
            return KeyConversion.relations[i].code;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof KeyBinding)) {
            return false;
        }
        KeyBinding keyBinding = (KeyBinding)object;
        return this.key == keyBinding.key && this.mask == keyBinding.mask;
    }

    public int hashCode() {
        return new Integer(this.key + this.mask).hashCode();
    }

    private static int getMaskCode(String string) {
        if (string.equals(ALT_STRING)) {
            return 65536;
        }
        if (string.equals(SHIFT_STRING)) {
            return 131072;
        }
        if (string.equals(CONTROL_STRING)) {
            return 262144;
        }
        return 0;
    }

    private String getMaskString() {
        String string = "";
        if ((this.mask & 0x10000) == 65536) {
            string = string + "Alt+";
        }
        if ((this.mask & 0x20000) == 131072) {
            string = string + "Shift+";
        }
        if ((this.mask & 0x40000) == 262144) {
            string = string + "Control+";
        }
        return string;
    }

    public String toString() {
        String string = this.getMaskString();
        String string2 = this.getSpecialKey();
        string = string2 != null ? string + string2 : string + (char)this.key;
        return string;
    }

    private String getSpecialKey() {
        for (int i = 0; i < KeyConversion.relations.length; ++i) {
            if (this.key != KeyConversion.relations[i].code) continue;
            return KeyConversion.relations[i].key;
        }
        return null;
    }

    public Object clone() {
        return new KeyBinding(this.getKey(), this.getMask());
    }
}

