/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;

public class ToolBarsOption
extends Option {
    private boolean changes = false;
    private List availableToolBars;
    private List customToolBars;
    private org.eclipse.swt.widgets.List availableList;
    private org.eclipse.swt.widgets.List customList;
    private Button addButton;
    private Button removeButton;
    private Button moveUpButton;
    private Button moveDownButton;

    public ToolBarsOption(ConfigEditor configEditor, ToolBar toolBar, Composite composite) {
        super(configEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.toolbars"), 4, 4);
        this.loadToolBars();
    }

    public void createOption() {
        Object object;
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.toolbars"));
        this.getToolItem().setImage(SystemImages.OPTION_TOOLBARS);
        this.getToolItem().addSelectionListener(this);
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(4, 4, true, true));
        this.availableList = new org.eclipse.swt.widgets.List(composite2, 2560);
        this.availableList.setLayoutData(new GridData(4, 4, true, true));
        for (int i = 0; i < this.availableToolBars.size(); ++i) {
            object = (String)this.availableToolBars.get(i);
            this.availableList.add(TuxGuitar.getProperty((String)object));
        }
        this.availableList.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarsOption.this.checkButtons();
            }
        });
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout(new GridLayout());
        composite3.setLayoutData(new GridData(4, 4, true, true));
        this.customList = new org.eclipse.swt.widgets.List(composite3, 2560);
        this.customList.setLayoutData(new GridData(4, 4, true, true));
        this.customList.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarsOption.this.checkButtons();
            }
        });
        object = new Composite(composite, 0);
        ((Composite)object).setLayout(new GridLayout());
        ((Control)object).setLayoutData(new GridData(4, 1024, true, true));
        this.addButton = new Button((Composite)object, 8);
        this.addButton.setLayoutData(new GridData(4, 4, true, true));
        this.addButton.setText("Add");
        this.addButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarsOption.this.addToolBar(ToolBarsOption.this.availableList.getSelectionIndex());
            }
        });
        Composite composite4 = new Composite(composite, 0);
        composite4.setLayout(new GridLayout(3, false));
        composite4.setLayoutData(new GridData(4, 1024, true, true));
        this.removeButton = new Button(composite4, 8);
        this.removeButton.setLayoutData(new GridData(4, 4, true, true));
        this.removeButton.setText("Remove");
        this.removeButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarsOption.this.removeToolBar(ToolBarsOption.this.customList.getSelectionIndex());
            }
        });
        this.moveUpButton = new Button(composite4, 132);
        this.moveUpButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarsOption.this.moveUp(ToolBarsOption.this.customList.getSelectionIndex());
            }
        });
        this.moveDownButton = new Button(composite4, 1028);
        this.moveDownButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarsOption.this.moveDown(ToolBarsOption.this.customList.getSelectionIndex());
            }
        });
        this.reloadList(-1);
    }

    public GridData makeButtonData(int n, int n2, int n3) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n2;
        gridData.minimumHeight = n3;
        gridData.horizontalAlignment = n;
        gridData.grabExcessHorizontalSpace = true;
        return gridData;
    }

    private void loadToolBars() {
        this.availableToolBars = TuxGuitar.instance().getItemManager().getAvailableToolBarNames();
        this.customToolBars = TuxGuitar.instance().getItemManager().getEnabledToolBars();
    }

    private void reloadList(int n) {
        this.customList.removeAll();
        for (String string : this.customToolBars) {
            this.customList.add(TuxGuitar.getProperty(string));
        }
        this.customList.select(n);
        this.checkButtons();
    }

    private void checkButtons() {
        int n;
        if (this.addButton != null && !this.addButton.isDisposed()) {
            n = 0;
            int n2 = this.availableList.getSelectionIndex();
            if (n2 >= 0 && n2 < this.availableToolBars.size()) {
                n = !this.exists((String)this.availableToolBars.get(n2)) ? 1 : 0;
            }
            this.addButton.setEnabled(n != 0);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            n = this.customList.getSelectionIndex();
            this.removeButton.setEnabled(n >= 0 && n < this.customToolBars.size());
        }
        if (this.moveUpButton != null && !this.moveUpButton.isDisposed()) {
            n = this.customList.getSelectionIndex();
            this.moveUpButton.setEnabled(n > 0 && n < this.customToolBars.size());
        }
        if (this.moveDownButton != null && !this.moveDownButton.isDisposed()) {
            n = this.customList.getSelectionIndex();
            this.moveDownButton.setEnabled(n >= 0 && n < this.customToolBars.size() - 1);
        }
    }

    private void addToolBar(int n) {
        String string;
        if (n >= 0 && n < this.availableToolBars.size() && !this.exists(string = (String)this.availableToolBars.get(n))) {
            this.customToolBars.add(string);
            this.reloadList(this.customToolBars.size() - 1);
            this.changes = true;
        }
    }

    private void removeToolBar(int n) {
        if (n >= 0 && n < this.customToolBars.size()) {
            this.customToolBars.remove(n);
            this.reloadList(this.customToolBars.size() > n ? n : this.customToolBars.size() - 1);
            this.changes = true;
        }
    }

    private void moveUp(int n) {
        if (n > 0 && n < this.customToolBars.size()) {
            String string = (String)this.customToolBars.get(n);
            this.customToolBars.remove(n);
            this.customToolBars.add(n - 1, string);
            this.reloadList(n - 1);
            this.changes = true;
        }
    }

    private void moveDown(int n) {
        if (n >= 0 && n < this.customToolBars.size() - 1) {
            String string = (String)this.customToolBars.get(n);
            this.customToolBars.remove(n);
            this.customToolBars.add(n + 1, string);
            this.reloadList(n + 1);
            this.changes = true;
        }
    }

    private boolean exists(String string) {
        for (String string2 : this.customToolBars) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void updateConfig() {
        TuxGuitar.instance().getItemManager().saveToolBars(this.customToolBars);
    }

    public void applyConfig(boolean bl) {
        if (this.changes || bl) {
            TuxGuitar.instance().loadToolBars();
        }
    }
}

