/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class SoundOption
extends Option {
    private Button useDefaultSoundbank;
    private Button useCustomSoundbank;
    private Text fileText;
    private Button fileButton;

    public SoundOption(ConfigEditor configEditor, ToolBar toolBar, Composite composite) {
        super(configEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.sound"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.sound"));
        this.getToolItem().setImage(SystemImages.OPTION_SOUND);
        this.getToolItem().addSelectionListener(this);
        this.showLabel(this.getComposite(), 16452, 1, 0, TuxGuitar.getProperty("settings.config.sound.soundbank"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(this.getTabbedData());
        this.useDefaultSoundbank = new Button(composite, 16);
        this.useDefaultSoundbank.setText(TuxGuitar.getProperty("settings.config.sound.default-soundbank"));
        this.useCustomSoundbank = new Button(composite, 16);
        this.useCustomSoundbank.setText(TuxGuitar.getProperty("settings.config.sound.custom-soundbank"));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(2, false));
        this.fileText = new Text(composite2, 2048);
        this.fileText.setLayoutData(new GridData(500, -1));
        this.fileButton = new Button(composite2, 8);
        this.fileButton.setImage(SystemImages.OPEN_IMAGE);
        this.fileButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = FileChooser.instance().open(SoundOption.this.getShell(), FileChooser.ALL_FORMAT);
                if (string != null) {
                    SoundOption.this.fileText.setText(string);
                    SoundOption.this.showRestartMessage();
                }
            }
        });
        this.useDefaultSoundbank.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (SoundOption.this.useDefaultSoundbank.getSelection()) {
                    SoundOption.this.fileText.setEnabled(false);
                    SoundOption.this.fileButton.setEnabled(false);
                    SoundOption.this.showRestartMessage();
                }
            }
        });
        this.useCustomSoundbank.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (SoundOption.this.useCustomSoundbank.getSelection()) {
                    SoundOption.this.fileText.setEnabled(true);
                    SoundOption.this.fileButton.setEnabled(true);
                }
            }
        });
        boolean bl = this.getConfig().getBooleanConfigValue("soundbank.custom");
        this.useDefaultSoundbank.setSelection(!bl);
        this.useCustomSoundbank.setSelection(bl);
        this.fileText.setEnabled(bl);
        this.fileButton.setEnabled(bl);
        if (bl) {
            this.fileText.setText(this.getConfig().getStringConfigValue("soundbank.custom.path"));
        }
    }

    private void showRestartMessage() {
        String string = TuxGuitar.getProperty("warning");
        String string2 = TuxGuitar.getProperty("settings.config.sound.soundbank-restart-message");
        new MessageDialog(string, string2, 2).show(this.getShell());
    }

    public void updateConfig() {
        boolean bl = this.useCustomSoundbank.getSelection();
        this.getConfig().setProperty("soundbank.custom", bl);
        if (bl) {
            this.getConfig().setProperty("soundbank.custom.path", this.fileText.getText());
        } else {
            this.getConfig().removeProperty("soundbank.custom.path");
        }
    }

    public void applyConfig(boolean bl) {
    }
}

