/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;

public class LanguageOption
extends Option {
    private Button[] languages;

    public LanguageOption(ConfigEditor configEditor, ToolBar toolBar, Composite composite) {
        super(configEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.language"));
    }

    public void createOption() {
        String[] stringArray;
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));
        this.getToolItem().setImage(SystemImages.OPTION_LANGUAGE);
        this.getToolItem().addSelectionListener(this);
        this.showLabel(this.getComposite(), 4, 16576, 1, 0, TuxGuitar.getProperty("settings.config.language.choose"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(this.getTabbedData());
        String string = this.getConfig().getStringConfigValue("language");
        if (string == null || string.trim().length() == 0) {
            string = TuxGuitar.instance().getLanguageManager().getLanguage();
        }
        if ((stringArray = TuxGuitar.instance().getLanguageManager().getLanguages()) != null) {
            this.languages = new Button[stringArray.length];
            for (int i = 0; i < this.languages.length; ++i) {
                this.languages[i] = new Button(composite, 16);
                this.languages[i].setData(stringArray[i]);
                this.languages[i].setText(TuxGuitar.getProperty(stringArray[i]));
                if (!stringArray[i].equals(string)) continue;
                this.languages[i].setSelection(true);
            }
        }
    }

    public void updateConfig() {
        String string = "";
        if (this.languages != null && this.languages.length > 0) {
            for (int i = 0; i < this.languages.length; ++i) {
                if (!this.languages[i].getSelection()) continue;
                string = (String)this.languages[i].getData();
            }
        }
        this.getConfig().setProperty("language", string);
    }

    public void applyConfig(boolean bl) {
        TuxGuitar.instance().loadLanguage();
        TuxGuitar.instance().loadProperties();
        TuxGuitar.instance().getMixer().update();
    }
}

