/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.system.config.ConfigManager;
import org.herac.tuxguitar.gui.system.config.items.LanguageOption;
import org.herac.tuxguitar.gui.system.config.items.MainOption;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.gui.system.config.items.StylesOption;
import org.herac.tuxguitar.gui.system.config.items.ToolBarsOption;
import org.herac.tuxguitar.gui.util.ConfirmDialog;

public class ConfigEditor {
    private ConfigManager config = TuxGuitar.instance().getConfig();
    private Shell dialog;
    private List options;

    public void showDialog(Shell shell) {
        this.dialog = new Shell(shell, 67680);
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("settings.config"));
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout(2, false));
        this.createComposites(composite);
        Composite composite2 = new Composite(this.dialog, 0);
        composite2.setLayout(new GridLayout(3, true));
        composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setLayoutData(this.makeGridData(80, 25));
        button.setText(TuxGuitar.getProperty("defaults"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigEditor.this.config.setDefaults();
                TuxGuitar.instance().getItemManager().saveDefaultToolBars();
                if (new ConfirmDialog(ConfigEditor.this.dialog, TuxGuitar.getProperty("settings.config.apply-changes-question")).confirm()) {
                    ConfigEditor.this.applyConfig(true);
                }
                ConfigEditor.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setLayoutData(this.makeGridData(80, 25));
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigEditor.this.updateOptions();
                if (new ConfirmDialog(ConfigEditor.this.dialog, TuxGuitar.getProperty("settings.config.apply-changes-question")).confirm()) {
                    ConfigEditor.this.applyConfig(false);
                }
                ConfigEditor.this.dialog.dispose();
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setLayoutData(this.makeGridData(80, 25));
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigEditor.this.dialog.dispose();
            }
        });
        this.dialog.pack();
        this.dialog.open();
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    private void createComposites(Composite composite) {
        ToolBar toolBar = new ToolBar(composite, 8389184);
        toolBar.setLayoutData(this.makeGridData(60, 350));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new FormLayout());
        composite2.setLayoutData(this.makeGridData(250, 350));
        this.initOptions(toolBar, composite2);
        if (this.options.size() > 0) {
            this.select((Option)this.options.get(0));
        }
    }

    private void initOptions(ToolBar toolBar, Composite composite) {
        this.options = new ArrayList();
        this.options.add(new MainOption(this, toolBar, composite));
        this.options.add(new StylesOption(this, toolBar, composite));
        this.options.add(new LanguageOption(this, toolBar, composite));
        this.options.add(new ToolBarsOption(this, toolBar, composite));
        Option option = TuxGuitar.instance().getPlayer().getConfigOption(this, toolBar, composite);
        if (option != null) {
            this.options.add(option);
        }
        for (Option option2 : this.options) {
            option2.createOption();
        }
    }

    public GridData makeGridData(int n, int n2) {
        return this.makeGridData(0, 0, n, n2);
    }

    public GridData makeGridData(int n, int n2, int n3, int n4) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n3;
        gridData.minimumHeight = n4;
        if (n > 0) {
            gridData.widthHint = n;
        } else {
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
        }
        if (n2 > 0) {
            gridData.heightHint = n;
        } else {
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
        }
        return gridData;
    }

    public void select(Option option) {
        this.hideAll();
        option.setVisible(true);
        this.dialog.layout();
    }

    private void hideAll() {
        for (Option option : this.options) {
            option.setVisible(false);
        }
    }

    private void updateOptions() {
        for (Option option : this.options) {
            option.updateConfig();
        }
        this.config.save();
    }

    private void applyConfig(boolean bl) {
        for (Option option : this.options) {
            option.applyConfig(bl);
        }
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().redraw();
    }

    public ConfigManager getConfig() {
        return this.config;
    }

    public TablatureEditor getEditor() {
        return TuxGuitar.instance().getTablatureEditor();
    }
}

