/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config;

import java.io.InputStream;
import java.util.Properties;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class ConfigDefaults {
    private Properties properties = new Properties();

    public ConfigDefaults() {
        this.loadDefaults();
        this.loadDefaultFile();
    }

    public void loadDefaultFile() {
        try {
            InputStream inputStream = TuxGuitarFileUtils.getResourceAsStream("defaults.properties");
            if (inputStream != null) {
                this.properties.load(inputStream);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadDefaults() {
        this.loadProperty("window.title", "${appname} - ${filename}");
        this.loadProperty("show.splash", true);
        this.loadProperty("window.maximized", false);
        this.loadProperty("window.width", 800);
        this.loadProperty("window.height", 600);
        this.loadProperty("show.mixer", false);
        this.loadProperty("show.transport", false);
        this.loadProperty("show.fretboard", false);
        this.loadProperty("show.piano", false);
        this.loadProperty("layout.mode", 2);
        this.loadProperty("show.multitrack", true);
        this.loadProperty("show.score", true);
        this.loadProperty("show.tablature", true);
        this.loadProperty("editor.mouse.mode", 2);
        this.loadProperty("editor.natural.key.mode", true);
        this.loadProperty("font.default", "Sans,6,2");
        this.loadProperty("font.note", "Sans,7,1");
        this.loadProperty("font.time-signature", "Sans,13,3");
        this.loadProperty("font.printer.default", "Sans,6,2");
        this.loadProperty("font.printer.note", "Sans,6,0");
        this.loadProperty("font.printer.time-signature", "Sans,12,3");
        this.loadProperty("font.lyric", "Sans,7,2");
        this.loadProperty("font.grace", "Sans,6,0");
        this.loadProperty("font.about.dialog.title", "Serif,36,3");
        this.loadProperty("color.line", "150,150,150");
        this.loadProperty("color.score.note", "0,0,0");
        this.loadProperty("color.tab.note", "0,0,0");
        this.loadProperty("color.play.note", "255,0,0");
        this.loadProperty("history.max-files", 10);
        this.loadProperty("score.autospacing", true);
        this.loadProperty("score.min.score-tab-span", 20);
        this.loadProperty("score.line-span", 8);
        this.loadProperty("tab.line-span", 10);
        this.loadProperty("first-track.span", 25);
        this.loadProperty("track.span", 10);
        this.loadProperty("fretboard.string-span", 20);
        this.loadProperty("language", "");
        this.loadProperty("soundbank.custom", false);
        this.loadProperty("system.player", "org.herac.tuxguitar.player.impl.MidiPlayerImpl");
        this.loadProperty("tablature.flags", 1);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void loadProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    private void loadProperty(String string, int n) {
        this.properties.setProperty(string, Integer.toString(n));
    }

    private void loadProperty(String string, boolean bl) {
        this.properties.setProperty(string, Boolean.toString(bl));
    }
}

