/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.scale;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.gui.scale.ScaleInfo;
import org.herac.tuxguitar.gui.scale.xml.ScaleReader;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;
import org.herac.tuxguitar.song.models.MusicScale;
import org.xml.sax.SAXException;

public class MusicScaleManager {
    private static final String[] KEY_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private static final String KEY_SEPARATOR = ",";
    public static final int NONE_SELECTION = -1;
    private List scales = new ArrayList();
    private MusicScale scale = new MusicScale();
    private int selectionIndex = -1;
    private int selectionKey = 0;

    public MusicScaleManager() {
        this.loadScales();
    }

    public MusicScale getScale() {
        return this.scale;
    }

    public void selectScale(int n, int n2) {
        if (n == -1) {
            this.getScale().clear();
        } else if (n >= 0 && n < this.scales.size()) {
            this.getScale().clear();
            ScaleInfo scaleInfo = (ScaleInfo)this.scales.get(n);
            String[] stringArray = scaleInfo.getKeys().split(KEY_SEPARATOR);
            for (int i = 0; i < stringArray.length; ++i) {
                int n3 = Integer.parseInt(stringArray[i]) - 1;
                if (n3 < 0 || n3 >= 12) continue;
                this.getScale().setNote(n3, true);
            }
            this.getScale().setKey(n2);
        }
        this.selectionIndex = n;
        this.selectionKey = n2;
    }

    public String[] getScaleNames() {
        String[] stringArray = new String[this.scales.size()];
        Iterator iterator = this.scales.iterator();
        for (int i = 0; i < this.scales.size(); ++i) {
            ScaleInfo scaleInfo = (ScaleInfo)this.scales.get(i);
            stringArray[i] = scaleInfo.getName();
        }
        return stringArray;
    }

    public String[] getKeyNames() {
        return KEY_NAMES;
    }

    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    public int getSelectionKey() {
        return this.selectionKey;
    }

    private void loadScales() {
        try {
            new ScaleReader().loadScales(this.scales, this.getScalesFileName());
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }

    private String getScalesFileName() {
        return TuxGuitarFileUtils.SCALES_PREFIX + File.separator + "scales.xml";
    }
}

