/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.printer;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;

public class PrintDocumentData {
    private int fromMeasure;
    private int toMeasure;
    private boolean scoreEnabled;
    private boolean tablatureEnabled;
    private int trackNumber;

    private PrintDocumentData() {
        this(-1, -1, -1, false, true);
    }

    public PrintDocumentData(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.trackNumber = n;
        this.fromMeasure = n2;
        this.toMeasure = n3;
        this.scoreEnabled = bl;
        this.tablatureEnabled = bl2;
    }

    public int getFromMeasure() {
        return this.fromMeasure;
    }

    public boolean isScoreEnabled() {
        return this.scoreEnabled;
    }

    public boolean isTablatureEnabled() {
        return this.tablatureEnabled;
    }

    public int getToMeasure() {
        return this.toMeasure;
    }

    public int getTrackNumber() {
        return this.trackNumber;
    }

    public static PrintDocumentData openDialog(Shell shell) {
        final PrintDocumentData printDocumentData = new PrintDocumentData();
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(TuxGuitar.getProperty("options"));
        Group group = new Group(shell2, 16);
        group.setLayout(new GridLayout(2, false));
        group.setLayoutData(PrintDocumentData.getGroupData());
        group.setText(TuxGuitar.getProperty("track"));
        Label label = new Label(group, 0);
        label.setText(TuxGuitar.getProperty("track"));
        final Combo combo = new Combo(group, 12);
        combo.setLayoutData(new GridData(4, 4, true, true));
        for (int i = 1; i <= TuxGuitar.instance().getSongManager().countTracks(); ++i) {
            combo.add(TuxGuitar.instance().getSongManager().getTrack(i).getName());
        }
        combo.select(TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber() - 1);
        Group group2 = new Group(shell2, 16);
        group2.setLayout(new GridLayout(2, false));
        group2.setLayoutData(PrintDocumentData.getGroupData());
        group2.setText(TuxGuitar.getProperty("print.range"));
        final int n = TuxGuitar.instance().getSongManager().countMeasures();
        Label label2 = new Label(group2, 0);
        label2.setText(TuxGuitar.getProperty("edit.from"));
        final Spinner spinner = new Spinner(group2, 2048);
        spinner.setLayoutData(PrintDocumentData.getSpinnerData());
        spinner.setMaximum(n);
        spinner.setMinimum(1);
        spinner.setSelection(1);
        Label label3 = new Label(group2, 0);
        label3.setText(TuxGuitar.getProperty("edit.to"));
        final Spinner spinner2 = new Spinner(group2, 2048);
        spinner2.setLayoutData(PrintDocumentData.getSpinnerData());
        spinner2.setMinimum(1);
        spinner2.setMaximum(n);
        spinner2.setSelection(n);
        spinner.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = spinner.getSelection();
                int n2 = spinner2.getSelection();
                if (n < 1) {
                    spinner.setSelection(1);
                } else if (n > n2) {
                    spinner.setSelection(n2);
                }
            }
        });
        spinner2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n3;
                int n2 = spinner2.getSelection();
                if (n2 < (n3 = spinner.getSelection())) {
                    spinner2.setSelection(n3);
                } else if (n2 > n) {
                    spinner2.setSelection(n);
                }
            }
        });
        Group group3 = new Group(shell2, 16);
        group3.setLayout(new GridLayout());
        group3.setLayoutData(PrintDocumentData.getGroupData());
        group3.setText(TuxGuitar.getProperty("options"));
        final Button button = new Button(group3, 32);
        button.setText(TuxGuitar.getProperty("export.tablature-enabled"));
        button.setSelection(true);
        final Button button2 = new Button(group3, 32);
        button2.setText(TuxGuitar.getProperty("export.score-enabled"));
        button2.setSelection(true);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!button.getSelection()) {
                    button2.setSelection(true);
                }
            }
        });
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!button2.getSelection()) {
                    button.setSelection(true);
                }
            }
        });
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button3 = new Button(composite, 8);
        button3.setText(TuxGuitar.getProperty("ok"));
        button3.setLayoutData(gridData);
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                printDocumentData.trackNumber = combo.getSelectionIndex() + 1;
                printDocumentData.fromMeasure = spinner.getSelection();
                printDocumentData.toMeasure = spinner2.getSelection();
                printDocumentData.scoreEnabled = button2.getSelection();
                printDocumentData.tablatureEnabled = button.getSelection();
                shell2.dispose();
            }
        });
        Button button4 = new Button(composite, 8);
        button4.setText(TuxGuitar.getProperty("cancel"));
        button4.setLayoutData(gridData);
        button4.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.pack();
        shell2.open();
        int n2 = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
        int n3 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
        shell2.setLocation(n2, n3);
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
        return printDocumentData.trackNumber > 0 ? printDocumentData : null;
    }

    private static GridData getSpinnerData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 60;
        return gridData;
    }

    private static GridData getGroupData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 300;
        return gridData;
    }
}

