/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.mixer.TrackMixer;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongMixer {
    private Shell dialog;
    private SongManager manager = TuxGuitar.instance().getSongManager();
    private Button metronome;
    private Scale volumeScale;
    private Text volumeText;
    private Label volumeLabel;
    private List trackMixers = new ArrayList();

    public static void main(String[] stringArray) {
        new SongMixer();
    }

    public void show() {
        Shell shell = TuxGuitar.instance().getTablatureEditor().getTablature().getShell();
        this.dialog = new Shell(shell, 2144);
        this.loadData();
        this.dialog.setLocation(this.getLocation(shell));
        this.dialog.open();
        TuxGuitar.instance().updateCache(true);
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        TuxGuitar.instance().updateCache(true);
    }

    private Point getLocation(Shell shell) {
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        return new Point(n, n2);
    }

    public void update() {
        if (!this.isDisposed()) {
            this.clear();
            this.loadData();
            this.dialog.layout();
        }
    }

    private void loadData() {
        Object object2;
        this.trackMixers.clear();
        List list = TuxGuitar.instance().getTablatureEditor().getSongManager().getSong().getTracks();
        for (Object object2 : list) {
            TrackMixer trackMixer = new TrackMixer(this, (SongTrack)object2);
            trackMixer.init(this.dialog);
            this.trackMixers.add(trackMixer);
        }
        object2 = new Composite(this.dialog, 0);
        ((Composite)object2).setLayout(new GridLayout());
        ((Control)object2).setLayoutData(new GridData(0x1000000, 4, true, true));
        this.metronome = new Button((Composite)object2, 2);
        this.metronome.setImage(SystemImages.MIXER_METRONOME);
        this.metronome.setSelection(TuxGuitar.instance().getPlayer().isMetronomeEnabled());
        this.metronome.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getPlayer().setMetronomeEnabled(SongMixer.this.metronome.getSelection());
            }
        });
        this.volumeLabel = new Label((Composite)object2, 0);
        this.volumeScale = new Scale((Composite)object2, 512);
        this.volumeScale.setMaximum(10);
        this.volumeScale.setMinimum(0);
        this.volumeScale.setIncrement(1);
        this.volumeScale.setPageIncrement(1);
        this.volumeScale.setLayoutData(new GridData(0x1000000, 4, true, true));
        this.volumeText = new Text((Composite)object2, 16779268);
        this.volumeText.setEditable(false);
        this.volumeText.setLayoutData(this.getVolumeTextData());
        this.volumeScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SongMixer.this.manager.getSong().setVolume((short)(SongMixer.this.volumeScale.getMaximum() - SongMixer.this.volumeScale.getSelection()));
                SongMixer.this.volumeScale.setToolTipText(TuxGuitar.getProperty("song.volume") + ": " + SongMixer.this.manager.getSong().getVolume());
                SongMixer.this.volumeText.setText(Integer.toString(SongMixer.this.volumeScale.getMaximum() - SongMixer.this.volumeScale.getSelection()));
                if (TuxGuitar.instance().getPlayer().isRunning()) {
                    TuxGuitar.instance().getPlayer().updateControllers();
                }
            }
        });
        this.volumeScale.setSelection(this.volumeScale.getMaximum() - this.manager.getSong().getVolume());
        this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
        this.loadProperties();
        this.dialog.setLayout(new GridLayout(this.dialog.getChildren().length, false));
        this.dialog.pack();
    }

    private GridData getVolumeTextData() {
        GridData gridData = new GridData(0x1000000, 0, true, false);
        gridData.minimumWidth = 40;
        return gridData;
    }

    private void clear() {
        Control[] controlArray = this.dialog.getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].dispose();
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void fireChanges(SongChannel songChannel) {
        for (TrackMixer trackMixer : this.trackMixers) {
            if (trackMixer.getTrack().getChannel().getChannel() != songChannel.getChannel()) continue;
            trackMixer.getTrack().getChannel().setVolume(songChannel.getVolume());
            trackMixer.getTrack().getChannel().setBalance(songChannel.getBalance());
            trackMixer.getTrack().getChannel().setChorus(songChannel.getChorus());
            trackMixer.getTrack().getChannel().setReverb(songChannel.getReverb());
            trackMixer.getTrack().getChannel().setPhaser(songChannel.getPhaser());
            trackMixer.getTrack().getChannel().setTremolo(songChannel.getTremolo());
            trackMixer.fireChanges();
        }
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updateControllers();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            for (TrackMixer trackMixer : this.trackMixers) {
                trackMixer.loadProperties();
            }
            this.volumeLabel.setText(TuxGuitar.getProperty("song.volume") + ":");
            this.volumeScale.setToolTipText(TuxGuitar.getProperty("song.volume") + ": " + this.manager.getSong().getVolume());
            this.metronome.setToolTipText(TuxGuitar.getProperty("metronome"));
            this.dialog.layout();
        }
    }
}

