/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.marker;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.undoables.JoinedUndoable;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeMarker;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Marker;

public class MarkerEditor {
    public static final int STATUS_NEW = 1;
    public static final int STATUS_EDIT = 2;
    private static final int MINIMUN_CONTROL_WIDTH = 180;
    private static final int MINIMUN_BUTTON_WIDTH = 80;
    private static final int MINIMUN_BUTTON_HEIGHT = 25;
    private int status;
    private Marker marker;
    private Shell dialog;
    private Spinner measureSpinner;
    private Text titleText;
    private Button colorButton;

    public MarkerEditor(Marker marker) {
        this(marker, 1);
    }

    public MarkerEditor(Marker marker, int n) {
        this.marker = (Marker)marker.clone();
        this.status = n;
    }

    public void show(Shell shell) {
        this.dialog = new Shell(shell, 67680);
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("marker"));
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        final int n = TuxGuitar.instance().getSongManager().countMeasures();
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label.setText(TuxGuitar.getProperty("measure"));
        this.measureSpinner = new Spinner(composite, 2048);
        this.measureSpinner.setLayoutData(this.getAlignmentData(180, 4));
        this.measureSpinner.setMinimum(1);
        this.measureSpinner.setMaximum(n);
        this.measureSpinner.setSelection(this.marker.getMeasure());
        this.measureSpinner.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n2 = MarkerEditor.this.measureSpinner.getSelection();
                if (n2 < 1) {
                    MarkerEditor.this.measureSpinner.setSelection(1);
                } else if (n2 > n) {
                    MarkerEditor.this.measureSpinner.setSelection(n);
                }
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label2.setText(TuxGuitar.getProperty("title"));
        this.titleText = new Text(composite, 2048);
        this.titleText.setLayoutData(this.getAlignmentData(180, 4));
        this.titleText.setText(this.marker.getTitle());
        Label label3 = new Label(composite, 0);
        label3.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label3.setText(TuxGuitar.getProperty("color"));
        this.colorButton = new Button(composite, 8);
        this.colorButton.setLayoutData(this.getAlignmentData(180, 4));
        this.colorButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(MarkerEditor.this.dialog);
                colorDialog.setRGB(MarkerEditor.this.dialog.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    MarkerEditor.this.marker.getColor().setR(rGB.red);
                    MarkerEditor.this.marker.getColor().setG(rGB.green);
                    MarkerEditor.this.marker.getColor().setB(rGB.blue);
                    MarkerEditor.this.colorButton.redraw();
                }
            }
        });
        this.colorButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Color color = new Color(MarkerEditor.this.dialog.getDisplay(), MarkerEditor.this.marker.getColor().getR(), MarkerEditor.this.marker.getColor().getG(), MarkerEditor.this.marker.getColor().getB());
                paintEvent.gc.setBackground(color);
                paintEvent.gc.fillRectangle(5, 5, ((MarkerEditor)MarkerEditor.this).colorButton.getSize().x - 10, ((MarkerEditor)MarkerEditor.this).colorButton.getSize().y - 10);
                color.dispose();
            }
        });
        Composite composite2 = new Composite(this.dialog, 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(gridData);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerEditor.this.updateMarker();
                MarkerEditor.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData(gridData);
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerEditor.this.dialog.dispose();
            }
        });
        this.dialog.pack();
        this.dialog.open();
        int n2 = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n3 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n2, n3);
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    private GridData getAlignmentData(int n, int n2) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.horizontalAlignment = n2;
        gridData.verticalAlignment = -1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }

    private void updateMarker() {
        UndoableChangeMarker undoableChangeMarker;
        int n = this.marker.getMeasure();
        this.marker.setMeasure(this.measureSpinner.getSelection());
        this.marker.setTitle(this.titleText.getText());
        this.marker = (Marker)this.marker.clone();
        SongManager songManager = TuxGuitar.instance().getSongManager();
        JoinedUndoable joinedUndoable = new JoinedUndoable();
        if (this.status == 2 && n != this.marker.getMeasure()) {
            undoableChangeMarker = UndoableChangeMarker.startUndo(songManager.getMarker(n));
            TuxGuitar.instance().getSongManager().removeMarker(n);
            joinedUndoable.addUndoableEdit(undoableChangeMarker.endUndo(null));
        }
        undoableChangeMarker = UndoableChangeMarker.startUndo(songManager.getMarker(this.marker.getMeasure()));
        TuxGuitar.instance().getSongManager().updateMarker(this.marker);
        joinedUndoable.addUndoableEdit(undoableChangeMarker.endUndo(this.marker));
        TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(joinedUndoable.endUndo());
    }
}

