/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ToolBarsWriter {
    private static final String ITEM_LIST_TAG = "toolbars";
    private static final String ITEM_TAG = "toolbar";
    private static final String NAME_ATTRIBUTE = "name";

    public void saveToolBars(List list, String string) {
        File file = new File(string);
        Document document = ToolBarsWriter.createDocument();
        ToolBarsWriter.setToolBars(list, document);
        ToolBarsWriter.saveDocument(document, file);
    }

    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public static void saveDocument(Document document, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private static void setToolBars(List list, Document document) {
        Element element = document.createElement(ITEM_LIST_TAG);
        for (String string : list) {
            Element element2 = document.createElement(ITEM_TAG);
            element.appendChild(element2);
            Attr attr = document.createAttribute(NAME_ATTRIBUTE);
            attr.setNodeValue(string);
            element2.getAttributes().setNamedItem(attr);
        }
        document.appendChild(element);
    }
}

