/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;

public class PlayerToolItems
extends ToolItems {
    public static final String NAME = "player.items";
    private static final int STATUS_STOPED = 1;
    private static final int STATUS_PAUSED = 2;
    private static final int STATUS_RUNNING = 3;
    private ToolBar toolBar;
    private ToolItem first;
    private ToolItem last;
    private ToolItem previous;
    private ToolItem next;
    private ToolItem stop;
    private ToolItem play;
    private int status;

    public PlayerToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.first = new ToolItem(toolBar, 8);
        this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_1);
        this.first.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoFirst(selectionEvent);
            }
        });
        this.previous = new ToolItem(toolBar, 8);
        this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_1);
        this.previous.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoPrevious(selectionEvent);
            }
        });
        this.stop = new ToolItem(toolBar, 8);
        this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
        this.stop.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().stop(selectionEvent);
            }
        });
        this.play = new ToolItem(toolBar, 8);
        this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
        this.play.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().play(selectionEvent);
            }
        });
        this.next = new ToolItem(toolBar, 8);
        this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_1);
        this.next.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoNext(selectionEvent);
            }
        });
        this.last = new ToolItem(toolBar, 8);
        this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_1);
        this.last.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoLast(selectionEvent);
            }
        });
        this.status = 1;
        this.loadProperties();
    }

    public void update() {
        int n = this.status;
        this.status = TuxGuitar.instance().getPlayer().isRunning() ? 3 : (TuxGuitar.instance().getPlayer().isPaused() ? 2 : 1);
        if (n != this.status) {
            if (this.status == 3) {
                this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_2);
                this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_2);
                this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_2);
                this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_2);
                this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
                this.play.setImage(SystemImages.TRANSPORT_ICON_PAUSE);
            } else if (this.status == 2) {
                this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_2);
                this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_2);
                this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_2);
                this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_2);
                this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
                this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_2);
            } else if (this.status == 1) {
                this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_1);
                this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_1);
                this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_1);
                this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_1);
                this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
                this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
            }
        }
    }

    public void loadProperties() {
        this.play.setToolTipText(TuxGuitar.getProperty("player.start"));
        this.stop.setToolTipText(TuxGuitar.getProperty("player.stop"));
    }
}

