/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.PageViewLayout;
import org.herac.tuxguitar.gui.items.ToolItems;

public class LayoutToolItems
extends ToolItems {
    public static final String NAME = "layout.items";
    private ToolBar toolBar;
    private ToolItem pageLayout;
    private ToolItem linearLayout;
    private ToolItem multitrack;
    private ToolItem scoreEnabled;

    public LayoutToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.pageLayout = new ToolItem(toolBar, 16);
        this.pageLayout.setImage(SystemImages.LAYOUT_PAGE);
        this.pageLayout.addSelectionListener(TuxGuitar.instance().getAction("action.view.layout-set-page"));
        this.linearLayout = new ToolItem(toolBar, 16);
        this.linearLayout.setImage(SystemImages.LAYOUT_LINEAR);
        this.linearLayout.addSelectionListener(TuxGuitar.instance().getAction("action.view.layout-set-linear"));
        this.multitrack = new ToolItem(toolBar, 32);
        this.multitrack.setImage(SystemImages.LAYOUT_MULTITRACK);
        this.multitrack.addSelectionListener(TuxGuitar.instance().getAction("action.view.layout-set-multitrack"));
        this.scoreEnabled = new ToolItem(toolBar, 32);
        this.scoreEnabled.setImage(SystemImages.LAYOUT_SCORE);
        this.scoreEnabled.addSelectionListener(TuxGuitar.instance().getAction("action.view.layout-set-score-enabled"));
        this.loadProperties();
    }

    public void loadProperties() {
        this.pageLayout.setToolTipText(TuxGuitar.getProperty("layout.page"));
        this.linearLayout.setToolTipText(TuxGuitar.getProperty("layout.linear"));
        this.multitrack.setToolTipText(TuxGuitar.getProperty("layout.multitrack"));
        this.scoreEnabled.setToolTipText(TuxGuitar.getProperty("layout.score-enabled"));
    }

    public void update() {
        this.pageLayout.setSelection(this.getEditor().getTablature().getViewLayout() instanceof PageViewLayout);
        this.linearLayout.setSelection(this.getEditor().getTablature().getViewLayout() instanceof LinearViewLayout);
        this.multitrack.setSelection(this.getEditor().getTablature().getViewLayout().isMultitrack());
        this.scoreEnabled.setSelection(this.getEditor().getTablature().getViewLayout().isScoreEnabled());
    }
}

