/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;

public class EditToolItems
extends ToolItems {
    public static final String NAME = "edit.items";
    private ToolBar toolBar;
    private ToolItem undo;
    private ToolItem redo;
    private ToolItem modeSelection;
    private ToolItem modeEdition;
    private ToolItem notNaturalKey;

    public EditToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.undo = new ToolItem(toolBar, 8);
        this.undo.setImage(SystemImages.EDIT_UNDO);
        this.undo.addSelectionListener(TuxGuitar.instance().getAction("action.edit.undo"));
        this.redo = new ToolItem(toolBar, 8);
        this.redo.setImage(SystemImages.EDIT_REDO);
        this.redo.addSelectionListener(TuxGuitar.instance().getAction("action.edit.redo"));
        new ToolItem(toolBar, 2);
        this.modeSelection = new ToolItem(toolBar, 16);
        this.modeSelection.setImage(SystemImages.EDIT_MODE_SELECTION);
        this.modeSelection.addSelectionListener(TuxGuitar.instance().getAction("action.edit.set-mouse-mode-selection"));
        this.modeEdition = new ToolItem(toolBar, 16);
        this.modeEdition.setImage(SystemImages.EDIT_MODE_EDITION);
        this.modeEdition.addSelectionListener(TuxGuitar.instance().getAction("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = new ToolItem(toolBar, 32);
        this.notNaturalKey.setImage(SystemImages.EDIT_MODE_EDITION_NO_NATURAL);
        this.notNaturalKey.addSelectionListener(TuxGuitar.instance().getAction("action.edit.set-natural-key"));
        this.loadProperties();
    }

    public void update() {
        this.undo.setEnabled(this.getEditor().getUndoManager().canUndo());
        this.redo.setEnabled(this.getEditor().getUndoManager().canRedo());
        this.modeSelection.setSelection(this.getEditor().getTablature().getEditorKit().getMouseMode() == 1);
        this.modeEdition.setSelection(this.getEditor().getTablature().getEditorKit().getMouseMode() == 2);
        this.notNaturalKey.setSelection(!this.getEditor().getTablature().getEditorKit().isNatural());
        this.notNaturalKey.setEnabled(this.getEditor().getTablature().getEditorKit().getMouseMode() == 2);
    }

    public void loadProperties() {
        this.undo.setToolTipText(TuxGuitar.getProperty("edit.undo"));
        this.redo.setToolTipText(TuxGuitar.getProperty("edit.redo"));
        this.modeSelection.setToolTipText(TuxGuitar.getProperty("edit.mouse-mode-selection"));
        this.modeEdition.setToolTipText(TuxGuitar.getProperty("edit.mouse-mode-edition"));
        this.notNaturalKey.setToolTipText(TuxGuitar.getProperty("edit.not-natural-key"));
    }
}

