/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.items.ToolItems;

public class DynamicToolItems
extends ToolItems {
    public static final String NAME = "dynamic.items";
    private ToolBar toolBar;
    private ToolItem pianoPianissimo;
    private ToolItem pianissimo;
    private ToolItem piano;
    private ToolItem mezzoPiano;
    private ToolItem mezzoForte;
    private ToolItem forte;
    private ToolItem fortissimo;
    private ToolItem forteFortissimo;

    public DynamicToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.pianoPianissimo = new ToolItem(this.toolBar, 32);
        this.pianoPianissimo.setImage(SystemImages.DYNAMIC_PIANO_PIANISSIMO);
        this.pianoPianissimo.setData(new Integer(15));
        this.pianoPianissimo.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.pianissimo = new ToolItem(this.toolBar, 32);
        this.pianissimo.setImage(SystemImages.DYNAMIC_PIANISSIMO);
        this.pianissimo.setData(new Integer(31));
        this.pianissimo.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.piano = new ToolItem(this.toolBar, 32);
        this.piano.setImage(SystemImages.DYNAMIC_PIANO);
        this.piano.setData(new Integer(47));
        this.piano.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.mezzoPiano = new ToolItem(this.toolBar, 32);
        this.mezzoPiano.setImage(SystemImages.DYNAMIC_MEZZO_PIANO);
        this.mezzoPiano.setData(new Integer(63));
        this.mezzoPiano.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.mezzoForte = new ToolItem(this.toolBar, 32);
        this.mezzoForte.setImage(SystemImages.DYNAMIC_MEZZO_FORTE);
        this.mezzoForte.setData(new Integer(79));
        this.mezzoForte.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.forte = new ToolItem(this.toolBar, 32);
        this.forte.setImage(SystemImages.DYNAMIC_FORTE);
        this.forte.setData(new Integer(95));
        this.forte.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.fortissimo = new ToolItem(this.toolBar, 32);
        this.fortissimo.setImage(SystemImages.DYNAMIC_FORTISSIMO);
        this.fortissimo.setData(new Integer(111));
        this.fortissimo.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.forteFortissimo = new ToolItem(this.toolBar, 32);
        this.forteFortissimo.setImage(SystemImages.DYNAMIC_FORTE_FORTISSIMO);
        this.forteFortissimo.setData(new Integer(127));
        this.forteFortissimo.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.loadProperties();
    }

    public void update() {
        Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        int n = caret.getSelectedNote() != null ? caret.getSelectedNote().getVelocity() : caret.getVelocity();
        this.pianoPianissimo.setSelection(n == 15);
        this.pianissimo.setSelection(n == 31);
        this.piano.setSelection(n == 47);
        this.mezzoPiano.setSelection(n == 63);
        this.mezzoForte.setSelection(n == 79);
        this.forte.setSelection(n == 95);
        this.fortissimo.setSelection(n == 111);
        this.forteFortissimo.setSelection(n == 127);
    }

    public void loadProperties() {
        this.pianoPianissimo.setToolTipText(TuxGuitar.getProperty("dynamic.piano-pianissimo"));
        this.pianissimo.setToolTipText(TuxGuitar.getProperty("dynamic.pianissimo"));
        this.piano.setToolTipText(TuxGuitar.getProperty("dynamic.piano"));
        this.mezzoPiano.setToolTipText(TuxGuitar.getProperty("dynamic.mezzo-piano"));
        this.mezzoForte.setToolTipText(TuxGuitar.getProperty("dynamic.mezzo-forte"));
        this.forte.setToolTipText(TuxGuitar.getProperty("dynamic.forte"));
        this.fortissimo.setToolTipText(TuxGuitar.getProperty("dynamic.fortissimo"));
        this.forteFortissimo.setToolTipText(TuxGuitar.getProperty("dynamic.forte-fortissimo"));
    }
}

