/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;

public class CompositionToolItems
extends ToolItems {
    public static final String NAME = "composition.items";
    private ToolBar toolBar;
    private ToolItem tempo;
    private ToolItem timeSignature;
    private ToolItem openRepeat;
    private ToolItem closeRepeat;

    public CompositionToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.tempo = new ToolItem(toolBar, 8);
        this.tempo.setImage(SystemImages.TEMPO_ICON_IMAGE);
        this.tempo.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-tempo"));
        this.timeSignature = new ToolItem(toolBar, 8);
        this.timeSignature.setImage(SystemImages.TIME_SIGNATURE_IMAGE);
        this.timeSignature.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-time-signature"));
        new ToolItem(toolBar, 2);
        this.openRepeat = new ToolItem(toolBar, 8);
        this.openRepeat.setImage(SystemImages.OPEN_REPEAT_IMAGE);
        this.openRepeat.addSelectionListener(TuxGuitar.instance().getAction("action.insert.open-repeat"));
        this.closeRepeat = new ToolItem(toolBar, 8);
        this.closeRepeat.setImage(SystemImages.CLOSE_REPEAT_IMAGE);
        this.closeRepeat.addSelectionListener(TuxGuitar.instance().getAction("action.insert.close-repeat"));
        this.loadProperties();
    }

    public void loadProperties() {
        this.tempo.setToolTipText(TuxGuitar.getProperty("composition.tempo"));
        this.timeSignature.setToolTipText(TuxGuitar.getProperty("composition.timesignature"));
        this.openRepeat.setToolTipText(TuxGuitar.getProperty("repeat.open"));
        this.closeRepeat.setToolTipText(TuxGuitar.getProperty("repeat.close"));
    }

    public void update() {
    }
}

