/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.gui.items.menu.ChordMenuItem;
import org.herac.tuxguitar.gui.items.menu.DurationMenuItem;
import org.herac.tuxguitar.gui.items.menu.DynamicMenuItem;
import org.herac.tuxguitar.gui.items.menu.NoteEffectsMenuItem;

public class NoteMenuItem
implements MenuItems {
    private TablatureEditor tablatureEditor;
    private MenuItem noteMenuItem;
    private Menu menu;
    private MenuItem tiedNote;
    private MenuItem cleanBeat;
    private MenuItem shiftUp;
    private MenuItem shiftDown;
    private MenuItem semitoneUp;
    private MenuItem semitoneDown;
    private DurationMenuItem durationMenuItem;
    private ChordMenuItem chordMenuItem;
    private NoteEffectsMenuItem effectMenuItem;
    private DynamicMenuItem dynamicMenuItem;

    public NoteMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.noteMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.tiedNote = new MenuItem(this.menu, 8);
        this.tiedNote.setImage(SystemImages.TIED_NOTE_IMAGE);
        this.tiedNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.tied"));
        this.cleanBeat = new MenuItem(this.menu, 8);
        this.cleanBeat.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.clean-beat"));
        this.durationMenuItem = new DurationMenuItem(this.menu.getShell(), this.menu, 64, this.tablatureEditor);
        this.durationMenuItem.showItems();
        this.chordMenuItem = new ChordMenuItem(this.menu.getShell(), this.menu, 64, this.tablatureEditor);
        this.chordMenuItem.showItems();
        this.effectMenuItem = new NoteEffectsMenuItem(this.menu.getShell(), this.menu, 64, this.tablatureEditor);
        this.effectMenuItem.showItems();
        this.dynamicMenuItem = new DynamicMenuItem(this.menu.getShell(), this.menu, 64, this.tablatureEditor);
        this.dynamicMenuItem.showItems();
        new MenuItem(this.menu, 2);
        this.semitoneUp = new MenuItem(this.menu, 8);
        this.semitoneUp.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.increment-semitone"));
        this.semitoneDown = new MenuItem(this.menu, 8);
        this.semitoneDown.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.decrement-semitone"));
        new MenuItem(this.menu, 2);
        this.shiftUp = new MenuItem(this.menu, 8);
        this.shiftUp.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.shift-up"));
        this.shiftDown = new MenuItem(this.menu, 8);
        this.shiftDown.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.shift-down"));
        this.noteMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
        this.durationMenuItem.update();
        this.chordMenuItem.update();
        this.effectMenuItem.update();
        this.dynamicMenuItem.update();
    }

    public void loadProperties() {
        this.noteMenuItem.setText(TuxGuitar.getProperty("note"));
        this.tiedNote.setText(TuxGuitar.getProperty("note.tiednote"));
        this.cleanBeat.setText(TuxGuitar.getProperty("note.clean-beat"));
        this.semitoneUp.setText(TuxGuitar.getProperty("note.semitone-up"));
        this.semitoneDown.setText(TuxGuitar.getProperty("note.semitone-down"));
        this.shiftUp.setText(TuxGuitar.getProperty("note.shift-up"));
        this.shiftDown.setText(TuxGuitar.getProperty("note.shift-down"));
        this.durationMenuItem.loadProperties();
        this.chordMenuItem.loadProperties();
        this.effectMenuItem.loadProperties();
        this.dynamicMenuItem.loadProperties();
    }
}

