/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class NoteEffectsMenuItem
implements MenuItems {
    private TablatureEditor tablatureEditor;
    private MenuItem noteEffectsMenuItem;
    private Menu menu;
    private MenuItem vibrato;
    private MenuItem bend;
    private MenuItem tremoloBar;
    private MenuItem deadNote;
    private MenuItem slide;
    private MenuItem hammer;
    private MenuItem ghostNote;
    private MenuItem accentuatedNote;
    private MenuItem heavyAccentuatedNote;
    private MenuItem harmonicNote;
    private MenuItem graceNote;
    private MenuItem trill;
    private MenuItem tremoloPicking;
    private MenuItem palmMute;
    private MenuItem staccato;
    private MenuItem tapping;
    private MenuItem slapping;
    private MenuItem popping;
    private MenuItem fadeIn;

    public NoteEffectsMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.noteEffectsMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.vibrato = new MenuItem(this.menu, 32);
        this.vibrato.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-vibrato"));
        this.bend = new MenuItem(this.menu, 32);
        this.bend.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-bend"));
        this.tremoloBar = new MenuItem(this.menu, 32);
        this.tremoloBar.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-tremolo-bar"));
        this.slide = new MenuItem(this.menu, 32);
        this.slide.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-slide"));
        this.deadNote = new MenuItem(this.menu, 32);
        this.deadNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-dead"));
        this.hammer = new MenuItem(this.menu, 32);
        this.hammer.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-hammer"));
        new MenuItem(this.menu, 2);
        this.ghostNote = new MenuItem(this.menu, 32);
        this.ghostNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-ghost"));
        this.accentuatedNote = new MenuItem(this.menu, 32);
        this.accentuatedNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-accentuated"));
        this.heavyAccentuatedNote = new MenuItem(this.menu, 32);
        this.heavyAccentuatedNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-heavy-accentuated"));
        this.harmonicNote = new MenuItem(this.menu, 32);
        this.harmonicNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-harmonic"));
        this.graceNote = new MenuItem(this.menu, 32);
        this.graceNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-grace"));
        new MenuItem(this.menu, 2);
        this.trill = new MenuItem(this.menu, 32);
        this.trill.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-trill"));
        this.tremoloPicking = new MenuItem(this.menu, 32);
        this.tremoloPicking.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-tremolo-picking"));
        this.palmMute = new MenuItem(this.menu, 32);
        this.palmMute.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-palm-mute"));
        this.staccato = new MenuItem(this.menu, 32);
        this.staccato.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-staccato"));
        new MenuItem(this.menu, 2);
        this.tapping = new MenuItem(this.menu, 32);
        this.tapping.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-tapping"));
        this.slapping = new MenuItem(this.menu, 32);
        this.slapping.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-slapping"));
        this.popping = new MenuItem(this.menu, 32);
        this.popping.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-popping"));
        new MenuItem(this.menu, 2);
        this.fadeIn = new MenuItem(this.menu, 32);
        this.fadeIn.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-fade-in"));
        this.noteEffectsMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
        Note note = this.tablatureEditor.getTablature().getCaret().getSelectedNote();
        NoteEffect noteEffect = note != null ? note.getEffect() : new NoteEffect();
        this.vibrato.setSelection(noteEffect.isVibrato());
        this.bend.setSelection(noteEffect.isBend());
        this.tremoloBar.setSelection(noteEffect.isTremoloBar());
        this.deadNote.setSelection(noteEffect.isDeadNote());
        this.slide.setSelection(noteEffect.isSlide());
        this.hammer.setSelection(noteEffect.isHammer());
        this.ghostNote.setSelection(noteEffect.isGhostNote());
        this.accentuatedNote.setSelection(noteEffect.isAccentuatedNote());
        this.heavyAccentuatedNote.setSelection(noteEffect.isHeavyAccentuatedNote());
        this.harmonicNote.setSelection(noteEffect.isHarmonic());
        this.graceNote.setSelection(noteEffect.isGrace());
        this.trill.setSelection(noteEffect.isTrill());
        this.tremoloPicking.setSelection(noteEffect.isTremoloPicking());
        this.palmMute.setSelection(noteEffect.isPalmMute());
        this.staccato.setSelection(noteEffect.isStaccato());
        this.tapping.setSelection(noteEffect.isTapping());
        this.slapping.setSelection(noteEffect.isSlapping());
        this.popping.setSelection(noteEffect.isPopping());
        this.fadeIn.setSelection(noteEffect.isFadeIn());
    }

    public void loadProperties() {
        this.noteEffectsMenuItem.setText(TuxGuitar.getProperty("effects"));
        this.vibrato.setText(TuxGuitar.getProperty("effects.vibrato"));
        this.bend.setText(TuxGuitar.getProperty("effects.bend"));
        this.tremoloBar.setText(TuxGuitar.getProperty("effects.tremolo-bar"));
        this.deadNote.setText(TuxGuitar.getProperty("effects.deadnote"));
        this.slide.setText(TuxGuitar.getProperty("effects.slide"));
        this.hammer.setText(TuxGuitar.getProperty("effects.hammer"));
        this.ghostNote.setText(TuxGuitar.getProperty("effects.ghostnote"));
        this.accentuatedNote.setText(TuxGuitar.getProperty("effects.accentuatednote"));
        this.heavyAccentuatedNote.setText(TuxGuitar.getProperty("effects.heavyaccentuatednote"));
        this.harmonicNote.setText(TuxGuitar.getProperty("effects.harmonic"));
        this.graceNote.setText(TuxGuitar.getProperty("effects.grace"));
        this.trill.setText(TuxGuitar.getProperty("effects.trill"));
        this.tremoloPicking.setText(TuxGuitar.getProperty("effects.tremolo-picking"));
        this.palmMute.setText(TuxGuitar.getProperty("effects.palm-mute"));
        this.staccato.setText(TuxGuitar.getProperty("effects.staccato"));
        this.tapping.setText(TuxGuitar.getProperty("effects.tapping"));
        this.slapping.setText(TuxGuitar.getProperty("effects.slapping"));
        this.popping.setText(TuxGuitar.getProperty("effects.popping"));
        this.fadeIn.setText(TuxGuitar.getProperty("effects.fade-in"));
    }
}

