/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;

public class EditMenuItem
implements MenuItems {
    private TablatureEditor tablatureEditor;
    private MenuItem editMenuItem;
    private Menu menu;
    private MenuItem undo;
    private MenuItem redo;
    private MenuItem modeSelection;
    private MenuItem modeEdition;
    private MenuItem notNaturalKey;

    public EditMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.editMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.undo = new MenuItem(this.menu, 8);
        this.undo.setImage(SystemImages.EDIT_UNDO);
        this.undo.addSelectionListener(TuxGuitar.instance().getAction("action.edit.undo"));
        this.redo = new MenuItem(this.menu, 8);
        this.redo.setImage(SystemImages.EDIT_REDO);
        this.redo.addSelectionListener(TuxGuitar.instance().getAction("action.edit.redo"));
        new MenuItem(this.menu, 2);
        this.modeSelection = new MenuItem(this.menu, 16);
        this.modeSelection.addSelectionListener(TuxGuitar.instance().getAction("action.edit.set-mouse-mode-selection"));
        this.modeEdition = new MenuItem(this.menu, 16);
        this.modeEdition.addSelectionListener(TuxGuitar.instance().getAction("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = new MenuItem(this.menu, 32);
        this.notNaturalKey.addSelectionListener(TuxGuitar.instance().getAction("action.edit.set-natural-key"));
        this.editMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
        this.undo.setEnabled(this.tablatureEditor.getUndoManager().canUndo());
        this.redo.setEnabled(this.tablatureEditor.getUndoManager().canRedo());
        this.modeSelection.setSelection(this.tablatureEditor.getTablature().getEditorKit().getMouseMode() == 1);
        this.modeEdition.setSelection(this.tablatureEditor.getTablature().getEditorKit().getMouseMode() == 2);
        this.notNaturalKey.setSelection(!this.tablatureEditor.getTablature().getEditorKit().isNatural());
        this.notNaturalKey.setEnabled(this.tablatureEditor.getTablature().getEditorKit().getMouseMode() == 2);
    }

    public void loadProperties() {
        this.editMenuItem.setText(TuxGuitar.getProperty("edit.menu"));
        this.undo.setText(TuxGuitar.getProperty("edit.undo"));
        this.redo.setText(TuxGuitar.getProperty("edit.redo"));
        this.modeSelection.setText(TuxGuitar.getProperty("edit.mouse-mode-selection"));
        this.modeEdition.setText(TuxGuitar.getProperty("edit.mouse-mode-edition"));
        this.notNaturalKey.setText(TuxGuitar.getProperty("edit.not-natural-key"));
    }
}

