/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.ItemBase;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.gui.items.menu.CompositionMenuItem;
import org.herac.tuxguitar.gui.items.menu.EditMenuItem;
import org.herac.tuxguitar.gui.items.menu.FileMenuItem;
import org.herac.tuxguitar.gui.items.menu.HelpMenuItem;
import org.herac.tuxguitar.gui.items.menu.LayoutMenuItem;
import org.herac.tuxguitar.gui.items.menu.MarkerMenuItem;
import org.herac.tuxguitar.gui.items.menu.MeasureMenuItem;
import org.herac.tuxguitar.gui.items.menu.NoteMenuItem;
import org.herac.tuxguitar.gui.items.menu.PlayMenuItem;
import org.herac.tuxguitar.gui.items.menu.PluginMenuItem;
import org.herac.tuxguitar.gui.items.menu.SettingsMenuItem;
import org.herac.tuxguitar.gui.items.menu.TrackMenuItem;
import org.herac.tuxguitar.gui.items.tool.CompositionToolItems;
import org.herac.tuxguitar.gui.items.tool.DurationToolItems;
import org.herac.tuxguitar.gui.items.tool.DynamicToolItems;
import org.herac.tuxguitar.gui.items.tool.EditToolItems;
import org.herac.tuxguitar.gui.items.tool.FileToolItems;
import org.herac.tuxguitar.gui.items.tool.LayoutToolItems;
import org.herac.tuxguitar.gui.items.tool.MarkerToolItems;
import org.herac.tuxguitar.gui.items.tool.NoteEffectToolItems;
import org.herac.tuxguitar.gui.items.tool.NoteToolItems;
import org.herac.tuxguitar.gui.items.tool.PlayerToolItems;
import org.herac.tuxguitar.gui.items.tool.PropertiesToolItems;
import org.herac.tuxguitar.gui.items.tool.TrackToolItems;
import org.herac.tuxguitar.gui.items.tool.ViewToolItems;
import org.herac.tuxguitar.gui.items.xml.ToolBarsReader;
import org.herac.tuxguitar.gui.items.xml.ToolBarsWriter;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class ItemManager {
    private static final int HEIGHT = 32;
    private static ToolItems[] AVAILABLE_TOOL_BARS = new ToolItems[]{new FileToolItems(), new EditToolItems(), new PropertiesToolItems(), new TrackToolItems(), new DurationToolItems(), new NoteToolItems(), new CompositionToolItems(), new PlayerToolItems(), new MarkerToolItems(), new LayoutToolItems(), new ViewToolItems(), new NoteEffectToolItems(), new DynamicToolItems()};
    private TablatureEditor tablatureEditor;
    private Menu menu;
    private Menu popupMenu;
    private CoolBar coolBar;
    private List toolItems;
    private List menuItems;
    private List popupMenuItems;
    private boolean layout_locked;

    public ItemManager(TablatureEditor tablatureEditor) {
        this.tablatureEditor = tablatureEditor;
        this.toolItems = new ArrayList();
        this.menuItems = new ArrayList();
        this.popupMenuItems = new ArrayList();
        this.layout_locked = false;
    }

    public void createItems(Shell shell) {
        this.createMenu(shell);
        this.createPopupMenu(shell);
        this.createCoolbar(shell);
    }

    public void createCoolbar(Shell shell) {
        this.coolBar = new CoolBar(shell, 0x800000);
        this.makeCoolItems();
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0, 0);
        this.coolBar.setLayoutData(formData);
        this.coolBar.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ItemManager.this.layoutCoolBar();
            }
        });
    }

    private void clearCoolBar() {
        if (this.coolBar != null && !this.coolBar.isDisposed()) {
            this.toolItems.clear();
            CoolItem[] coolItemArray = this.coolBar.getItems();
            for (int i = 0; i < coolItemArray.length; ++i) {
                coolItemArray[i].dispose();
            }
            Control[] controlArray = this.coolBar.getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].dispose();
            }
        }
    }

    private void layoutCoolBar() {
        if (!this.layout_locked) {
            this.layout_locked = true;
            this.coolBar.getParent().layout();
            this.coolBar.layout();
            this.layout_locked = false;
        }
    }

    public void makeCoolItems() {
        this.clearCoolBar();
        List list = this.getEnabledToolBars();
        block0: for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            for (int j = 0; j < AVAILABLE_TOOL_BARS.length; ++j) {
                if (!AVAILABLE_TOOL_BARS[j].getName().trim().toLowerCase().equals(string.trim().toLowerCase())) continue;
                this.makeToolBar(AVAILABLE_TOOL_BARS[j]);
                continue block0;
            }
        }
        this.layoutCoolBar();
    }

    private void makeToolBar(ToolItems toolItems) {
        ToolBar toolBar = new ToolBar(this.coolBar, 0x800040);
        toolItems.showItems(toolBar);
        this.makeCoolItem(toolBar);
        this.toolItems.add(toolItems);
    }

    private void makeCoolItem(ToolBar toolBar) {
        CoolItem coolItem = new CoolItem(this.coolBar, 0);
        coolItem.setControl(toolBar);
        Point point = toolBar.computeSize(-1, -1);
        Point point2 = coolItem.computeSize(point.x, 32);
        coolItem.setMinimumSize(point2);
        coolItem.setSize(point2);
    }

    public List getEnabledToolBars() {
        return this.loadEnableToolBars(this.getAvailableToolBarNames());
    }

    public List getAvailableToolBarNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < AVAILABLE_TOOL_BARS.length; ++i) {
            arrayList.add(AVAILABLE_TOOL_BARS[i].getName());
        }
        return arrayList;
    }

    public void createMenu(Shell shell) {
        this.menu = new Menu(shell, 2);
        this.menuItems.add(new FileMenuItem(shell, this.menu, 64, this.tablatureEditor));
        this.menuItems.add(new EditMenuItem(shell, this.menu, 64, this.tablatureEditor));
        this.menuItems.add(new LayoutMenuItem(shell, this.menu, 64, this.tablatureEditor));
        this.menuItems.add(new CompositionMenuItem(shell, this.menu, 64, this.tablatureEditor));
        this.menuItems.add(new TrackMenuItem(shell, this.menu, 64, this.tablatureEditor));
        this.menuItems.add(new MeasureMenuItem(shell, this.menu, 64, this.tablatureEditor));
        this.menuItems.add(new NoteMenuItem(shell, this.menu, 64, this.tablatureEditor));
        this.menuItems.add(new MarkerMenuItem(shell, this.menu, 64, this.tablatureEditor));
        this.menuItems.add(new PlayMenuItem(shell, this.menu, 64, this.tablatureEditor));
        this.menuItems.add(new SettingsMenuItem(shell, this.menu, 64));
        this.menuItems.add(new PluginMenuItem(shell, this.menu, 64));
        this.menuItems.add(new HelpMenuItem(shell, this.menu, 64));
        this.showMenuItems(this.menuItems);
        shell.setMenuBar(this.menu);
    }

    public void createPopupMenu(Shell shell) {
        this.popupMenu = new Menu(shell, 8);
        this.popupMenuItems.add(new EditMenuItem(shell, this.popupMenu, 64, this.tablatureEditor));
        this.popupMenuItems.add(new CompositionMenuItem(shell, this.popupMenu, 64, this.tablatureEditor));
        this.popupMenuItems.add(new TrackMenuItem(shell, this.popupMenu, 64, this.tablatureEditor));
        this.popupMenuItems.add(new MeasureMenuItem(shell, this.popupMenu, 64, this.tablatureEditor));
        this.popupMenuItems.add(new NoteMenuItem(shell, this.popupMenu, 64, this.tablatureEditor));
        this.popupMenuItems.add(new MarkerMenuItem(shell, this.popupMenu, 64, this.tablatureEditor));
        this.popupMenuItems.add(new PlayMenuItem(shell, this.popupMenu, 64, this.tablatureEditor));
        this.showMenuItems(this.popupMenuItems);
    }

    private void showMenuItems(List list) {
        for (MenuItems menuItems : list) {
            menuItems.showItems();
        }
    }

    public void updateItems() {
        if (!this.isDisposed()) {
            this.updateItems(this.toolItems);
            this.updateItems(this.menuItems);
            this.updateItems(this.popupMenuItems);
        }
    }

    public void updateItems(List list) {
        for (ItemBase itemBase : list) {
            itemBase.update();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.loadProperties(this.toolItems);
            this.loadProperties(this.menuItems);
            this.loadProperties(this.popupMenuItems);
        }
    }

    public void loadProperties(List list) {
        for (ItemBase itemBase : list) {
            itemBase.loadProperties();
        }
    }

    public CoolBar getCoolbar() {
        return this.coolBar;
    }

    public Menu getPopupMenu() {
        return this.popupMenu;
    }

    public List loadEnableToolBars(List list) {
        File file = new File(this.getCoolItemsFileName());
        if (!file.exists()) {
            this.saveToolBars(list);
        }
        return new ToolBarsReader().loadToolBars(file);
    }

    public void saveToolBars(List list) {
        new ToolBarsWriter().saveToolBars(list, this.getCoolItemsFileName());
    }

    public void saveDefaultToolBars() {
        this.saveToolBars(this.getAvailableToolBarNames());
    }

    private boolean isDisposed() {
        return this.coolBar.isDisposed() || this.menu.isDisposed() || this.popupMenu.isDisposed();
    }

    private String getCoolItemsFileName() {
        return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + "toolbars.xml";
    }
}

