/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class FileHistory {
    private static final int PATH_LIMIT = TuxGuitar.instance().getConfig().getIntConfigValue("history.max-files");
    private boolean pathChanges;
    private boolean isNewFile;
    private List paths;

    public FileHistory() {
        this.clearFile();
        this.loadHistory();
    }

    public void clearFile() {
        this.isNewFile = true;
    }

    public String getFileName() {
        if (!this.isNewFile() && !this.paths.isEmpty()) {
            return new File((String)this.paths.get(0)).getName();
        }
        return "Untitled.gp4";
    }

    public String getFilePath() {
        if (!this.paths.isEmpty()) {
            return new File((String)this.paths.get(0)).getParent();
        }
        return null;
    }

    public boolean isNewFile() {
        return this.isNewFile;
    }

    public void setFile(String string) {
        this.isNewFile = false;
        this.addPath(string);
    }

    public void addPath(String string) {
        if (string != null && string.length() > 0) {
            this.removePath(string);
            this.paths.add(0, string);
            this.checkLimit();
            this.saveHistory();
            this.setPathChanges(true);
        }
    }

    public List getPaths() {
        return this.paths;
    }

    private void checkLimit() {
        while (this.paths.size() > PATH_LIMIT) {
            this.paths.remove(this.paths.size() - 1);
        }
    }

    private void removePath(String string) {
        for (int i = 0; i < this.paths.size(); ++i) {
            String string2 = (String)this.paths.get(i);
            if (!string2.equals(string)) continue;
            this.paths.remove(i);
            break;
        }
    }

    public boolean hasPathChanges() {
        return this.pathChanges;
    }

    public void setPathChanges(boolean bl) {
        this.pathChanges = bl;
    }

    public void loadHistory() {
        try {
            this.paths = new ArrayList();
            if (new File(this.getHistoryFileName()).exists()) {
                FileInputStream fileInputStream = new FileInputStream(this.getHistoryFileName());
                Properties properties = new Properties();
                properties.load(fileInputStream);
                int n = Integer.parseInt((String)properties.get("history.count"));
                for (int i = 0; i < n; ++i) {
                    String string = (String)properties.get("history." + i);
                    if (PATH_LIMIT <= i || string == null || string.length() <= 0) continue;
                    this.paths.add((String)properties.get("history." + i));
                }
                this.setPathChanges(true);
            } else {
                this.saveHistory();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveHistory() {
        try {
            Properties properties = new Properties();
            int n = this.paths.size();
            for (int i = 0; i < n; ++i) {
                properties.put("history." + i, this.paths.get(i));
            }
            properties.put("history.count", Integer.toString(n));
            properties.store(new FileOutputStream(this.getHistoryFileName()), "History Files");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getHistoryFileName() {
        return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + "history.properties";
    }
}

