/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.effects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.TremoloBarEffect;

public class TremoloBarEditor {
    public static final int X_SPAN = 30;
    public static final int Y_SPAN = 10;
    private static final int X_LENGTH = 13;
    private static final int Y_LENGTH = 25;
    private Composite editor;
    private int[] x;
    private int[] y;
    private int width;
    private int height;
    private List points;
    private DefaultTremoloBar[] defaultTremoloBars;
    private boolean isEditing;
    private TremoloBarEffect result;

    public TremoloBarEditor() {
        this.init();
    }

    private void init() {
        int n;
        this.x = new int[13];
        this.y = new int[25];
        this.width = 360;
        this.height = 240;
        this.points = new ArrayList();
        for (n = 0; n < this.x.length; ++n) {
            this.x[n] = (n + 1) * 30;
        }
        for (n = 0; n < this.y.length; ++n) {
            this.y[n] = (n + 1) * 10;
        }
    }

    public TremoloBarEffect show(Shell shell, final Note note) {
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(TuxGuitar.getProperty("effects.tremolo-bar-editor"));
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout(new GridLayout());
        composite3.setLayoutData(new GridData(4, 4, true, true));
        this.isEditing = note.getEffect().isTremoloBar();
        this.editor = new Composite(composite2, 0x20000800);
        this.editor.setBackground(this.editor.getDisplay().getSystemColor(1));
        this.editor.setLayoutData(this.resizeData(new GridData(4, 4, true, true), this.getWidth() + 60, this.getHeight() + 20));
        this.editor.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TremoloBarEditor.this.paintEditor(paintEvent.gc);
                paintEvent.gc.dispose();
            }
        });
        this.editor.addMouseListener(new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TremoloBarEditor.this.checkPoint(mouseEvent.x, mouseEvent.y);
                TremoloBarEditor.this.editor.redraw();
            }
        });
        if (this.isEditing) {
            this.setTremoloBar(note.getEffect().getTremoloBar());
        }
        final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite3, 2048);
        this.resetDefaultTremoloBars();
        for (int i = 0; i < this.defaultTremoloBars.length; ++i) {
            list.add(this.defaultTremoloBars[i].getName());
        }
        list.setLayoutData(new GridData(4, 4, true, true));
        list.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!TremoloBarEditor.this.isEditing && list.getSelectionIndex() >= 0) {
                    TremoloBarEditor.this.setTremoloBar(TremoloBarEditor.this.defaultTremoloBars[list.getSelectionIndex()].getTremoloBar());
                    TremoloBarEditor.this.editor.redraw();
                }
                TremoloBarEditor.this.isEditing = false;
            }
        });
        Button button = new Button(composite3, 8);
        button.setLayoutData(this.resizeData(new GridData(4, 1024, true, true), 80, 25));
        button.setText(TuxGuitar.getProperty("clean"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TremoloBarEditor.this.result = null;
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setLayoutData(this.resizeData(new GridData(4, 1024, true, false), 80, 25));
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TremoloBarEditor.this.result = TremoloBarEditor.this.getTremoloBar();
                shell2.dispose();
            }
        });
        Button button3 = new Button(composite3, 8);
        button3.setLayoutData(this.resizeData(new GridData(4, 1024, true, false), 80, 25));
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TremoloBarEditor.this.result = note.getEffect().getTremoloBar();
                shell2.dispose();
            }
        });
        shell2.pack();
        int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
        shell2.setLocation(n, n2);
        shell2.open();
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
        return this.result;
    }

    private GridData resizeData(GridData gridData, int n, int n2) {
        gridData.minimumWidth = n;
        gridData.minimumHeight = n2;
        return gridData;
    }

    private void paintEditor(GC gC) {
        int n;
        gC.setAdvanced(true);
        for (n = 0; n < this.x.length; ++n) {
            this.setStyleX(gC, n);
            gC.drawLine(this.x[n], 10, this.x[n], 10 + this.height);
        }
        for (n = 0; n < this.y.length; ++n) {
            this.setStyleY(gC, n);
            gC.drawLine(30, this.y[n], 30 + this.width, this.y[n]);
        }
        Iterator iterator = null;
        Point point = null;
        gC.setLineStyle(1);
        gC.setLineWidth(2);
        gC.setForeground(this.editor.getDisplay().getSystemColor(15));
        for (Point point2 : this.points) {
            if (point != null) {
                gC.drawLine(point.x, point.y, point2.x, point2.y);
            }
            point = point2;
        }
        gC.setLineWidth(5);
        gC.setForeground(this.editor.getDisplay().getSystemColor(2));
        for (Point point2 : this.points) {
            gC.drawRectangle(point2.x - 2, point2.y - 2, 5, 5);
        }
        gC.setLineWidth(1);
    }

    private void setStyleX(GC gC, int n) {
        gC.setLineStyle(1);
        if (n == 0 || n == 12) {
            gC.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else {
            gC.setForeground(this.editor.getDisplay().getSystemColor(9));
            if (n % 3 > 0) {
                gC.setLineStyle(3);
            }
        }
    }

    private void setStyleY(GC gC, int n) {
        gC.setLineStyle(1);
        if (n == 0 || n == 24) {
            gC.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else if (n == 12) {
            gC.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else {
            gC.setForeground(this.editor.getDisplay().getSystemColor(3));
            if (n % 2 > 0) {
                gC.setLineStyle(3);
                gC.setForeground(this.editor.getDisplay().getSystemColor(15));
            }
        }
    }

    private void checkPoint(int n, int n2) {
        Point point = new Point(this.getX(n), this.getY(n2));
        if (!this.removePoint(point)) {
            this.removePointsAtXLine(point.x);
            this.addPoint(point);
            this.orderPoints();
        }
    }

    private boolean removePoint(Point point) {
        for (Point point2 : this.points) {
            if (point2.x != point.x || point2.y != point.y) continue;
            this.points.remove(point);
            return true;
        }
        return false;
    }

    private void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = null;
            for (int j = i; j < this.points.size(); ++j) {
                Point point2 = (Point)this.points.get(j);
                if (point != null && point2.x >= point.x) continue;
                point = point2;
            }
            this.points.remove(point);
            this.points.add(i, point);
        }
    }

    private void removePointsAtXLine(int n) {
        for (Point point : this.points) {
            if (point.x != n) continue;
            this.points.remove(point);
            break;
        }
    }

    private void addPoint(Point point) {
        this.points.add(point);
    }

    private int getX(int n) {
        int n2 = -1;
        for (int i = 0; i < this.x.length; ++i) {
            if (n2 < 0) {
                n2 = this.x[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.x[i]);
            if (n4 >= n3) continue;
            n2 = this.x[i];
        }
        return n2;
    }

    private int getY(int n) {
        int n2 = -1;
        for (int i = 0; i < this.y.length; ++i) {
            if (n2 < 0) {
                n2 = this.y[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.y[i]);
            if (n4 >= n3) continue;
            n2 = this.y[i];
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public TremoloBarEffect getTremoloBar() {
        if (this.points != null && !this.points.isEmpty()) {
            TremoloBarEffect tremoloBarEffect = new TremoloBarEffect();
            for (Point point : this.points) {
                this.addTremoloBarPoint(tremoloBarEffect, point);
            }
            return tremoloBarEffect;
        }
        return null;
    }

    private void addTremoloBarPoint(TremoloBarEffect tremoloBarEffect, Point point) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.x.length; ++n) {
            if (point.x != this.x[n]) continue;
            n2 = n;
        }
        for (n = 0; n < this.y.length; ++n) {
            if (point.y != this.y[n]) continue;
            n3 = 12 - n;
        }
        tremoloBarEffect.addPoint(n2, n3);
    }

    public void setTremoloBar(TremoloBarEffect tremoloBarEffect) {
        this.points.clear();
        for (TremoloBarEffect.TremoloBarPoint tremoloBarPoint : tremoloBarEffect.getPoints()) {
            this.makePoint(tremoloBarPoint);
        }
    }

    private void makePoint(TremoloBarEffect.TremoloBarPoint tremoloBarPoint) {
        int n = tremoloBarPoint.getPosition();
        int n2 = this.y.length - 12 - tremoloBarPoint.getValue() - 1;
        if (n >= 0 && n < this.x.length && n2 >= 0 && n2 < this.y.length) {
            Point point = new Point(0, 0);
            point.x = this.x[n];
            point.y = this.y[n2];
            this.points.add(point);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private void resetDefaultTremoloBars() {
        this.defaultTremoloBars = new DefaultTremoloBar[6];
        this.defaultTremoloBars[0] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.dip"), new TremoloBarEffect());
        this.defaultTremoloBars[0].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[0].getTremoloBar().addPoint(6, -2);
        this.defaultTremoloBars[0].getTremoloBar().addPoint(12, 0);
        this.defaultTremoloBars[1] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.dive"), new TremoloBarEffect());
        this.defaultTremoloBars[1].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[1].getTremoloBar().addPoint(9, -2);
        this.defaultTremoloBars[1].getTremoloBar().addPoint(12, -2);
        this.defaultTremoloBars[2] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.release-up"), new TremoloBarEffect());
        this.defaultTremoloBars[2].getTremoloBar().addPoint(0, -2);
        this.defaultTremoloBars[2].getTremoloBar().addPoint(9, -2);
        this.defaultTremoloBars[2].getTremoloBar().addPoint(12, 0);
        this.defaultTremoloBars[3] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.inverted-dip"), new TremoloBarEffect());
        this.defaultTremoloBars[3].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[3].getTremoloBar().addPoint(6, 2);
        this.defaultTremoloBars[3].getTremoloBar().addPoint(12, 0);
        this.defaultTremoloBars[4] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.return"), new TremoloBarEffect());
        this.defaultTremoloBars[4].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[4].getTremoloBar().addPoint(9, 2);
        this.defaultTremoloBars[4].getTremoloBar().addPoint(12, 2);
        this.defaultTremoloBars[5] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.release-down"), new TremoloBarEffect());
        this.defaultTremoloBars[5].getTremoloBar().addPoint(0, 2);
        this.defaultTremoloBars[5].getTremoloBar().addPoint(9, 2);
        this.defaultTremoloBars[5].getTremoloBar().addPoint(12, 0);
    }

    private class DefaultTremoloBar {
        private String name;
        private TremoloBarEffect tremoloBar;

        public DefaultTremoloBar(String string, TremoloBarEffect tremoloBarEffect) {
            this.name = string;
            this.tremoloBar = tremoloBarEffect;
        }

        public TremoloBarEffect getTremoloBar() {
            return this.tremoloBar;
        }

        public String getName() {
            return this.name;
        }
    }
}

