/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.effects;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;

public class HarmonicEditor
extends SelectionAdapter {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 0;
    private Button natural;
    private Button artificial;
    private Button tapped;
    private Button pinch;
    private Button semi;
    private Label artificialLabel;
    private Combo artificialKey;
    private Label tappedLeftHand;
    private Label tappedLeftHandSelection;
    private Label tappedRightHand;
    private Combo tappedSelection;
    private HarmonicEffect result;

    public HarmonicEffect show(final Note note) {
        Shell shell = TuxGuitar.instance().getShell();
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(TuxGuitar.getProperty("effects.harmonic-editor"));
        Group group = new Group(shell2, 16);
        group.setLayout(new GridLayout());
        group.setLayoutData(this.resizeData(new GridData(4, 4, true, true), 400));
        group.setText(TuxGuitar.getProperty("effects.harmonic.type-of-harmonic"));
        this.natural = new Button(group, 16);
        this.natural.setText("[N.H] " + TuxGuitar.getProperty("effects.harmonic.natural"));
        this.natural.setLayoutData(new GridData(16384, 4, true, true));
        this.natural.addSelectionListener(this);
        this.natural.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isNatural());
        this.artificial = new Button(group, 16);
        this.artificial.setText("[A.H] " + TuxGuitar.getProperty("effects.harmonic.artificial"));
        this.artificial.setLayoutData(new GridData(16384, 4, true, true));
        this.artificial.addSelectionListener(this);
        this.artificial.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isArtificial());
        Composite composite = new Composite(group, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.artificialLabel = new Label(composite, 0);
        this.artificialLabel.setText(TuxGuitar.getProperty("effects.harmonic.artificial.key-offset"));
        this.artificialLabel.setLayoutData(new GridData(0, 0x1000000, false, true));
        this.artificialKey = new Combo(composite, 12);
        this.artificialKey.setLayoutData(new GridData(4, 4, true, true));
        for (int i = -24; i <= 24; ++i) {
            this.artificialKey.add(Integer.toString(i));
        }
        if (note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isArtificial()) {
            this.artificialKey.select(note.getEffect().getHarmonic().getData() - -24);
        } else {
            this.artificialKey.select(24);
        }
        this.tapped = new Button(group, 16);
        this.tapped.setText("[T.H] " + TuxGuitar.getProperty("effects.harmonic.tapped"));
        this.tapped.setLayoutData(new GridData(16384, 4, true, true));
        this.tapped.addSelectionListener(this);
        this.tapped.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isTapped());
        Composite composite2 = new Composite(group, 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(new GridData(4, 4, true, true));
        this.tappedLeftHand = new Label(composite2, 0);
        this.tappedLeftHand.setText(TuxGuitar.getProperty("effects.harmonic.tapped.left-hand") + ":");
        this.tappedLeftHand.setLayoutData(new GridData(0, 0x1000000, false, true));
        this.tappedLeftHandSelection = new Label(composite2, 0);
        this.tappedLeftHandSelection.setLayoutData(new GridData(16384, 0x1000000, true, true));
        this.tappedLeftHandSelection.setText(" 1");
        this.tappedRightHand = new Label(composite2, 0);
        this.tappedRightHand.setText(TuxGuitar.getProperty("effects.harmonic.tapped.right-hand") + ":");
        this.tappedRightHand.setLayoutData(new GridData(0, 0x1000000, false, true));
        this.tappedSelection = new Combo(composite2, 12);
        this.tappedSelection.setLayoutData(new GridData(4, 4, true, true));
        for (int i = note.getValue(); i <= 24; ++i) {
            this.tappedSelection.add(Integer.toString(i));
        }
        if (note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isTapped()) {
            this.tappedSelection.select(note.getEffect().getHarmonic().getData());
        } else {
            this.tappedSelection.select(0);
        }
        this.pinch = new Button(group, 16);
        this.pinch.setText("[P.H] " + TuxGuitar.getProperty("effects.harmonic.pinch"));
        this.pinch.setLayoutData(new GridData(16384, 4, true, true));
        this.pinch.addSelectionListener(this);
        this.pinch.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isPinch());
        this.semi = new Button(group, 16);
        this.semi.setText("[S.H] " + TuxGuitar.getProperty("effects.harmonic.semi"));
        this.semi.setLayoutData(new GridData(16384, 4, true, true));
        this.semi.addSelectionListener(this);
        this.semi.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isSemi());
        Composite composite3 = new Composite(shell2, 0);
        composite3.setLayout(new GridLayout(3, false));
        composite3.setLayoutData(new GridData(0x1000008, 1024, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite3, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(gridData);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HarmonicEditor.this.result = HarmonicEditor.this.getHarmonic();
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setText(TuxGuitar.getProperty("clean"));
        button2.setLayoutData(gridData);
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HarmonicEditor.this.result = null;
                shell2.dispose();
            }
        });
        Button button3 = new Button(composite3, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData(gridData);
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HarmonicEditor.this.result = note.getEffect().getHarmonic();
                shell2.dispose();
            }
        });
        if (!note.getEffect().isHarmonic()) {
            this.natural.setSelection(true);
        }
        this.updateControls();
        shell2.pack();
        shell2.open();
        int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
        shell2.setLocation(n, n2);
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
        return this.result;
    }

    private GridData resizeData(GridData gridData, int n) {
        gridData.minimumWidth = n;
        return gridData;
    }

    private GridData spanData(GridData gridData, int n) {
        gridData.horizontalSpan = n;
        return gridData;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.updateControls();
    }

    public void updateControls() {
        this.artificialLabel.setEnabled(this.artificial.getSelection());
        this.artificialKey.setEnabled(this.artificial.getSelection());
        this.tappedLeftHand.setEnabled(this.tapped.getSelection());
        this.tappedLeftHandSelection.setEnabled(this.tapped.getSelection());
        this.tappedRightHand.setEnabled(this.tapped.getSelection());
        this.tappedSelection.setEnabled(this.tapped.getSelection());
    }

    public HarmonicEffect getHarmonic() {
        if (this.natural.getSelection()) {
            return new HarmonicEffect(1);
        }
        if (this.artificial.getSelection()) {
            return new HarmonicEffect(2, -24 + this.artificialKey.getSelectionIndex());
        }
        if (this.tapped.getSelection()) {
            return new HarmonicEffect(3, this.tappedSelection.getSelectionIndex());
        }
        if (this.pinch.getSelection()) {
            return new HarmonicEffect(4);
        }
        if (this.semi.getSelection()) {
            return new HarmonicEffect(5);
        }
        return null;
    }
}

