/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.MeasureHeaderGui;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.util.ImageUtils;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;

public abstract class ViewLayout {
    public static final int MODE_PAGE = 1;
    public static final int MODE_LINEAR = 2;
    public static final int DEFAULT_MODE = 2;
    private static final int SCORE_NOTE_EMPTY_NORMAL_MODE = 0;
    private static final int SCORE_NOTE_EMPTY_PLAY_MODE = 1;
    private static final int SCORE_NOTE_FULL_NORMAL_MODE = 2;
    private static final int SCORE_NOTE_FULL_PLAY_MODE = 3;
    public static final boolean AUTO_SPACING_ENABLED = TuxGuitar.instance().getConfig().getBooleanConfigValue("score.autospacing");
    protected static final int DEFAULT_HORIZONTAL_SPAN = 20;
    protected static final int DEFAULT_MIN_TOP_SPAN = 30;
    protected static final int MIN_SCORE_TAB_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue("score.min.score-tab-span");
    protected static final int DEFAULT_SCORE_LINE_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue("score.line-span");
    protected static final int DEFAULT_SCORE_SPAN = DEFAULT_SCORE_LINE_SPAN * 4 + MIN_SCORE_TAB_SPAN;
    protected static final int DEFAULT_FIRST_TRACK_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue("first-track.span");
    protected static final int DEFAULT_TRACK_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue("track.span");
    protected static final int DEFAULT_STRING_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue("tab.line-span");
    public static final int DEFAULT_EFFECT_SPAN = 8;
    private Tablature tablature;
    private SongManager songManager;
    private boolean multitrack;
    private boolean scoreEnabled;
    private boolean tablatureEnabled;
    private List trackPositions;
    private int width;
    private int height;
    private int scoreSpan;
    private Image[] scoreNotes;
    private Image[] harmonicNotes;
    private int scoreNoteWidth;
    private boolean playModeEnabled;

    public ViewLayout(Tablature tablature, SongManager songManager, boolean bl, boolean bl2, boolean bl3) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.multitrack = bl;
        this.scoreEnabled = bl2;
        this.tablatureEnabled = bl3;
        this.trackPositions = new ArrayList();
        this.playModeEnabled = false;
        this.initScoreNotes();
        this.initHarmonicNotes();
    }

    public abstract void paintSong(GC var1, Rectangle var2, int var3, int var4);

    public abstract void paintTracks(List var1, GC var2, Rectangle var3, int var4, int var5);

    public abstract boolean followMeasure(MeasureCoords var1, boolean var2);

    public abstract int getMode();

    public void paint(GC gC, Rectangle rectangle, int n, int n2) {
        this.paintSong(gC, rectangle, n, n2);
    }

    public void paintMeasure(MeasureCoords measureCoords, GC gC, int n, int n2, int n3, Rectangle rectangle) {
        measureCoords.setSpan(n3);
        measureCoords.paintMeasure(this, gC, rectangle);
    }

    public void updateSong() {
        this.disposeTracks();
        this.updateTracks();
        this.updateCaret();
    }

    public void updateTracks() {
        int n = this.getSongManager().countTracks();
        int n2 = this.getSongManager().countMeasures();
        this.getTablature().getSongCoords().create(n, n2);
        for (int i = 0; i < n2; ++i) {
            Object object;
            SongTrackCoords songTrackCoords;
            int n3;
            MeasureHeaderGui measureHeaderGui = this.getTablature().getSongCoords().getHeaderByIndex(i);
            measureHeaderGui.update(this);
            for (n3 = 0; n3 < n; ++n3) {
                songTrackCoords = this.getTablature().getSongCoords().getTrackByIndex(n3);
                object = (Measure)songTrackCoords.getTrack().getMeasures().get(i);
                MeasureCoords measureCoords = new MeasureCoords(this.getSongManager(), this.getTablature(), measureHeaderGui, (Measure)object, songTrackCoords);
                measureCoords.create(this);
                songTrackCoords.getMeasuresCoords().add(measureCoords);
            }
            for (n3 = 0; n3 < n; ++n3) {
                songTrackCoords = this.getTablature().getSongCoords().getTrackByIndex(n3);
                object = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(i);
                ((MeasureCoords)object).update(this);
            }
            measureHeaderGui.calculateWidth();
        }
        this.songManager.calculateMeasureStartWithRepetitions();
    }

    public void updateLyrics() {
        int n = this.getSongManager().countTracks();
        for (int i = 0; i < n; ++i) {
            SongTrackCoords songTrackCoords = this.getTablature().getSongCoords().getTrackByIndex(i);
            songTrackCoords.getLyricPainter().update();
        }
    }

    private void updateCaret() {
        this.tablature.getCaret().update();
    }

    public void fireUpdate(int n, boolean bl) {
        MeasureCoords measureCoords;
        SongTrackCoords songTrackCoords;
        int n2;
        int n3 = n - 1;
        int n4 = this.getSongManager().countTracks();
        MeasureHeaderGui measureHeaderGui = this.getTablature().getSongCoords().getHeaderByIndex(n3);
        measureHeaderGui.update(this);
        for (n2 = 0; n2 < n4; ++n2) {
            songTrackCoords = this.getTablature().getSongCoords().getTrackByIndex(n2);
            measureCoords = null;
            if (bl) {
                Measure measure = (Measure)songTrackCoords.getTrack().getMeasures().get(n3);
                measureCoords = new MeasureCoords(this.getSongManager(), this.getTablature(), measureHeaderGui, measure, songTrackCoords);
                songTrackCoords.getMeasuresCoords().add(measureCoords);
            } else {
                measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(n3);
            }
            measureCoords.create(this);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            songTrackCoords = this.getTablature().getSongCoords().getTrackByIndex(n2);
            measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(n3);
            measureCoords.update(this);
        }
        measureHeaderGui.calculateWidth();
        this.updateCaret();
    }

    public Image getScoreNote(int n, boolean bl) {
        int n2 = 0;
        n2 += bl ? 1 : 0;
        return this.scoreNotes[n2 += n >= 4 ? 2 : 0];
    }

    public Image getHarmonicNote(int n, boolean bl) {
        int n2 = 0;
        n2 += bl ? 1 : 0;
        return this.harmonicNotes[n2 += n >= 4 ? 2 : 0];
    }

    private void initScoreNotes() {
        this.scoreNotes = new Image[4];
        try {
            this.scoreNotes[0] = this.makeScoreNoteImage(this.tablature.getScoreNoteColor(), false);
            this.scoreNotes[1] = this.makeScoreNoteImage(this.tablature.getPlayNoteColor(), false);
            this.scoreNotes[2] = this.makeScoreNoteImage(this.tablature.getScoreNoteColor(), true);
            this.scoreNotes[3] = this.makeScoreNoteImage(this.tablature.getPlayNoteColor(), true);
        }
        catch (SWTException sWTException) {
            this.scoreNotes[0] = this.makeOldScoreNoteImage(this.tablature.getScoreNoteColor(), false);
            this.scoreNotes[1] = this.makeOldScoreNoteImage(this.tablature.getPlayNoteColor(), false);
            this.scoreNotes[2] = this.makeOldScoreNoteImage(this.tablature.getScoreNoteColor(), true);
            this.scoreNotes[3] = this.makeOldScoreNoteImage(this.tablature.getPlayNoteColor(), true);
        }
    }

    private void initHarmonicNotes() {
        this.harmonicNotes = new Image[4];
        this.harmonicNotes[0] = this.makeArmonicImage(this.tablature.getScoreNoteColor(), false);
        this.harmonicNotes[1] = this.makeArmonicImage(this.tablature.getPlayNoteColor(), false);
        this.harmonicNotes[2] = this.makeArmonicImage(this.tablature.getScoreNoteColor(), true);
        this.harmonicNotes[3] = this.makeArmonicImage(this.tablature.getPlayNoteColor(), true);
    }

    public int getScoreNoteWidth() {
        return this.scoreNoteWidth;
    }

    private Image makeOldScoreNoteImage(Color color, boolean bl) {
        int n = this.getScoreLineSpan();
        Image image = new Image((Device)this.getTablature().getDisplay(), n, n);
        GC gC = new GC(image);
        gC.setAdvanced(true);
        gC.setForeground(color);
        gC.drawOval(0, 1, n - 2, n - 2);
        if (bl) {
            gC.setBackground(color);
            gC.fillOval(0, 1, n - 2, n - 2);
        }
        ImageData imageData = image.getImageData();
        ImageData imageData2 = ImageUtils.applyMask(imageData, new RGB(255, 255, 255), new RGB(0, 0, 0));
        gC.dispose();
        image.dispose();
        this.scoreNoteWidth = n - 2;
        return new Image((Device)this.getTablature().getDisplay(), imageData, imageData2);
    }

    private Image makeScoreNoteImage(Color color, boolean bl) {
        int n = 0;
        int n2 = 1;
        int n3 = (bl ? this.getScoreLineSpan() : this.getScoreLineSpan() - 1) - 1;
        int n4 = Math.round((float)n3 / 3.0f * 4.0f) + 1;
        int n5 = n3 + 1;
        float f = (float)n3 / 3.0f;
        float f2 = n;
        float f3 = (float)n2 + f * 2.0f;
        float f4 = (float)n + f;
        float f5 = (float)n2 + f * 3.0f;
        float f6 = (float)n + f * 4.0f;
        float f7 = (float)n2 + f;
        float f8 = (float)n + f * 3.0f;
        float f9 = n2;
        Path path = new Path(this.getTablature().getDisplay());
        path.moveTo(f2, f3);
        path.cubicTo(f2, f5 - (f5 - f3) / 2.0f, f4 - (f4 - f2) / 2.0f, f5, f4, f5);
        path.cubicTo(f4 + (f6 - f4) / 2.0f, f5, f6, f7 + (f5 - f7) / 2.0f, f6, f7);
        path.cubicTo(f6, f9 + (f7 - f9) / 2.0f, f8 + (f6 - f8) / 2.0f, f9, f8, f9);
        path.cubicTo(f8 - (f8 - f2) / 2.0f, f9, f2, f3 - (f3 - f9) / 2.0f, f2, f3);
        Image image = new Image((Device)this.getTablature().getDisplay(), n + n4, n2 + n5);
        GC gC = new GC(image);
        if (bl) {
            gC.setBackground(color);
            gC.fillPath(path);
        } else {
            gC.setForeground(color);
            gC.drawPath(path);
        }
        gC.dispose();
        ImageData imageData = image.getImageData();
        ImageData imageData2 = ImageUtils.applyMask(imageData, new RGB(255, 255, 255), new RGB(0, 0, 0));
        image.dispose();
        this.scoreNoteWidth = (int)((float)(this.getScoreLineSpan() - 1) / 3.0f * 4.0f);
        return new Image((Device)this.getTablature().getDisplay(), imageData, imageData2);
    }

    private Image makeArmonicImage(Color color, boolean bl) {
        int n = this.getScoreLineSpan();
        int n2 = 0;
        int n3 = 1;
        int n4 = this.getScoreNoteWidth() - 1;
        int n5 = n - 2;
        int[] nArray = new int[]{n2, n3 + n5 / 2, n2 + n4 / 2, n3 + n5, n2 + n4 / 2, n3 + n5, n2 + n4, n3 + n5 / 2, n2 + n4, n3 + n5 / 2, n2 + n4 / 2, n3, n2 + n4 / 2, n3, n2, n3 + n5 / 2};
        Image image = new Image((Device)this.getTablature().getDisplay(), n2 + n4 + 2, n3 + n5 + 2);
        GC gC = new GC(image);
        gC.setAdvanced(true);
        gC.setForeground(color);
        gC.drawPolygon(nArray);
        if (bl) {
            gC.setBackground(color);
            gC.fillPolygon(nArray);
        }
        ImageData imageData = image.getImageData();
        ImageData imageData2 = ImageUtils.applyMask(imageData, new RGB(255, 255, 255), new RGB(0, 0, 0));
        gC.dispose();
        image.dispose();
        return new Image((Device)this.getTablature().getDisplay(), imageData, imageData2);
    }

    public void paintLines(SongTrackCoords songTrackCoords, TrackSpacing trackSpacing, GC gC, int n, int n2, int n3) {
        if (n3 > 0) {
            n = n < 0 ? 0 : n;
            this.setLineColor(gC);
            if (this.isScoreEnabled()) {
                int n4 = n2 + trackSpacing.getPosition(2);
                for (int i = 1; i <= 5; ++i) {
                    gC.drawLine(n, n4, n + n3, n4);
                    n4 += this.getScoreLineSpan();
                }
            }
            if (this.isTablatureEnabled()) {
                n2 += trackSpacing.getPosition(12);
                for (InstrumentString instrumentString : songTrackCoords.getTrack().getStrings()) {
                    gC.drawLine(n, n2, n + n3, n2);
                    n2 += this.getStringSpan();
                }
            }
        }
    }

    public void paintCaret(GC gC) {
        Caret caret;
        if (this.isCaretVisible() && (this.isTablatureEnabled() || this.isScoreEnabled()) && !(caret = this.getTablature().getCaret()).getMeasureCoords().isOutOfBounds()) {
            caret.paintCaret(this, gC);
        }
    }

    public void paintCacheMode(GC gC, MeasureCoords measureCoords, List list, boolean bl, boolean bl2) {
        this.playModeEnabled = bl2;
        if (bl) {
            measureCoords.paintMeasure(this, gC, null);
        }
        this.setNoteStyle(gC);
        for (MeasureComponent measureComponent : list) {
            measureComponent.paint(this, gC, measureCoords.getPosX() + 15, measureCoords.getPosY());
        }
        measureCoords.getTrackCoords().getLyricPainter().paintCurrentNoteBeats(gC, this, measureCoords, measureCoords.getPosX(), measureCoords.getPosY());
        this.playModeEnabled = false;
    }

    protected void checkTopSpan(TrackSpacing trackSpacing) {
        if (this.isScoreEnabled() && trackSpacing.getPosition(2) < 30) {
            trackSpacing.setSize(0, 30 - trackSpacing.getPosition(2));
        } else if (this.isTablatureEnabled() && trackSpacing.getPosition(12) < 30) {
            trackSpacing.setSize(0, 30 - trackSpacing.getPosition(12));
        }
    }

    public int getSpanForQuarter(Duration duration) {
        double d = 1000.0 / (double)duration.getTime() * (double)this.getMinSpan(duration);
        return (int)d;
    }

    private int getMinSpan(Duration duration) {
        int n = 0;
        switch (duration.getValue()) {
            case 1: {
                n = 50;
                break;
            }
            case 2: {
                n = 30;
                break;
            }
            case 4: {
                n = 25;
                break;
            }
            case 8: {
                n = 20;
                break;
            }
            default: {
                n = 18;
            }
        }
        return n;
    }

    public boolean isCaretVisible() {
        return true;
    }

    public boolean isPlayModeEnabled() {
        return this.playModeEnabled;
    }

    public void setDefaultStyle(GC gC) {
        gC.setFont(this.tablature.getDefaultFont());
    }

    public void setNoteStyle(GC gC) {
        gC.setFont(this.tablature.getNoteFont());
    }

    public void setGraceStyle(GC gC) {
        gC.setFont(this.tablature.getGraceFont());
    }

    public void setLyricStyle(GC gC) {
        gC.setFont(this.tablature.getLyricFont());
    }

    public void setTimeSignatureStyle(GC gC) {
        gC.setFont(this.tablature.getTimeSignatureFont());
    }

    public void setLineColor(GC gC) {
        gC.setForeground(this.tablature.getLineColor());
    }

    public void setScoreNoteColor(GC gC) {
        gC.setForeground(this.tablature.getScoreNoteColor());
    }

    public void setTabNoteColor(GC gC) {
        gC.setForeground(this.tablature.getTabNoteColor());
    }

    public void setPlayNoteColor(GC gC) {
        gC.setForeground(this.tablature.getPlayNoteColor());
    }

    public void setOfflineEffectStyle(GC gC) {
        gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
        gC.setFont(this.tablature.getDefaultFont());
    }

    public void setTupletoStyle(GC gC) {
        gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
        gC.setFont(this.tablature.getDefaultFont());
    }

    public Rectangle getNoteOrientation(GC gC, int n, int n2, Note note) {
        String string = null;
        if (note.isTiedNote()) {
            string = "L";
            string = note.getEffect().isGhostNote() ? "(" + string + ")" : string;
        } else if (note.getEffect().isDeadNote()) {
            string = "X";
            string = note.getEffect().isGhostNote() ? "(" + string + ")" : string;
        } else {
            string = Integer.toString(note.getValue());
            string = note.getEffect().isGhostNote() ? "(" + string + ")" : string;
        }
        return this.getOrientation(gC, n, n2, string);
    }

    public Rectangle getOrientation(GC gC, int n, int n2, String string) {
        Point point = gC.stringExtent(string);
        return new Rectangle(n - point.x / 2, n2 - point.y / 2, point.x, point.y);
    }

    protected boolean isMultiTrack() {
        return true;
    }

    protected int getTrackCount() {
        if (this.multitrack) {
            return this.songManager.getSong().getTracks().size();
        }
        return 1;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public void setTablature(Tablature tablature) {
        this.tablature = tablature;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public boolean isMultitrack() {
        return this.multitrack;
    }

    public void setMultitrack(boolean bl) {
        this.multitrack = bl;
    }

    public boolean isScoreEnabled() {
        return this.scoreEnabled;
    }

    public void setScoreEnabled(boolean bl) {
        this.scoreEnabled = bl;
    }

    public boolean isTablatureEnabled() {
        return this.tablatureEnabled;
    }

    public void setTablatureEnabled(boolean bl) {
        this.tablatureEnabled = bl;
    }

    public int getStringSpan() {
        return DEFAULT_STRING_SPAN;
    }

    public int getScoreLineSpan() {
        return DEFAULT_SCORE_LINE_SPAN;
    }

    private int getScoreSpan() {
        return this.scoreSpan;
    }

    public void setScoreSpan(int n) {
        this.scoreSpan = n;
    }

    public int getDefaultTrackSpan() {
        return DEFAULT_TRACK_SPAN;
    }

    public int getMinScoreTabSpan() {
        return MIN_SCORE_TAB_SPAN;
    }

    public int getDefaultEffectSpan() {
        return 8;
    }

    public int getDefaultFirstTrackSpan() {
        return DEFAULT_FIRST_TRACK_SPAN;
    }

    public boolean isFirstMeasure(Measure measure) {
        return measure.getNumber() == 1;
    }

    public boolean isLastMeasure(Measure measure) {
        return measure.getNumber() == this.getSongManager().countMeasures();
    }

    protected void clearTrackPositions() {
        this.trackPositions.clear();
    }

    protected void addTrackPosition(int n, int n2, int n3) {
        this.trackPositions.add(new TrackPosition(n, n2, n3));
    }

    public int getTrackNumberAt(List list, int n) {
        TrackPosition trackPosition = this.getTrackPositionAt(n);
        return trackPosition != null ? trackPosition.getTrack() : -1;
    }

    public TrackPosition getTrackPositionAt(int n) {
        TrackPosition trackPosition = null;
        int n2 = 0;
        for (TrackPosition trackPosition2 : this.trackPositions) {
            int n3 = Math.min(Math.abs(n - trackPosition2.getPosY()), Math.abs(n - (trackPosition2.getPosY() + trackPosition2.getHeight() - 10)));
            if (trackPosition != null && n3 >= n2) continue;
            trackPosition = trackPosition2;
            n2 = n3;
        }
        return trackPosition;
    }

    public void disposeLayout() {
        this.disposeTracks();
        this.disposeScoreNotes();
    }

    protected void disposeScoreNotes() {
        if (this.scoreNotes != null) {
            for (int i = 0; i < this.scoreNotes.length; ++i) {
                this.scoreNotes[i].dispose();
            }
        }
    }

    protected void disposeHarmonicNotes() {
        if (this.harmonicNotes != null) {
            for (int i = 0; i < this.harmonicNotes.length; ++i) {
                this.harmonicNotes[i].dispose();
            }
        }
    }

    protected void disposeTracks() {
        this.getTablature().getSongCoords().disposeTracks();
    }

    public class TrackPosition {
        private int track;
        private int posY;
        private int height;

        public TrackPosition(int n, int n2, int n3) {
            this.track = n;
            this.posY = n2;
            this.height = n3;
        }

        public int getPosY() {
            return this.posY;
        }

        public int getHeight() {
            return this.height;
        }

        public int getTrack() {
            return this.track;
        }
    }
}

