/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintDocumentData;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;

public class PrinterViewLayout
extends ViewLayout {
    public static final boolean AUTO_SPACING_ENABLED = true;
    protected static final int DEFAULT_SCORE_LINE_SPAN = 7;
    protected static final int DEFAULT_STRING_SPAN = 8;
    protected static final int MIN_SCORE_TAB_SPAN = 20;
    protected static final int DEFAULT_SCORE_SPAN = 55;
    protected static final int DEFAULT_TRACK_SPAN = 8;
    protected static final int DEFAULT_FIRST_TRACK_SPAN = 8;
    private PrintDocument document;
    private PrintDocumentData documentData;
    private Image image;
    private int divisionCount;

    public PrinterViewLayout(Tablature tablature, SongManager songManager, PrintDocumentData printDocumentData) {
        super(tablature, songManager, false, printDocumentData.isScoreEnabled(), printDocumentData.isTablatureEnabled());
        this.documentData = printDocumentData;
    }

    public int getMode() {
        return 0;
    }

    public PrintDocument makeDocument(Rectangle rectangle) {
        this.document = new PrintDocument();
        this.document.setPageSize(rectangle);
        this.image = new Image((Device)this.getTablature().getDisplay(), this.document.getPageSize());
        GC gC = new GC(this.image);
        this.paintHeader(gC);
        this.paintSong(gC, 0, 80);
        gC.dispose();
        this.image.dispose();
        return this.document;
    }

    private void makePage(GC gC) {
        String string = Integer.toString(this.document.count() + 1);
        this.setDefaultStyle(gC);
        gC.setForeground(this.getTablature().getDisplay().getSystemColor(2));
        gC.drawString(string, this.getRight(gC, string), this.document.getPageSize().height - (gC.stringExtent((String)string).y + 5));
        this.document.makePage(this.image.getImageData());
        gC.fillRectangle(this.document.getPageSize());
    }

    public void paintHeader(GC gC) {
        String string = this.getSongManager().getSong().getName();
        String string2 = this.getSongManager().getSong().getAuthor();
        String string3 = "(" + this.getSongManager().getTrack(this.documentData.getTrackNumber()).getName() + ")";
        if (string == null || string.length() == 0) {
            string = TuxGuitar.getProperty("print-header.default-song-name");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = TuxGuitar.getProperty("print-header.default-song-author");
        }
        Font font = new Font(this.getTablature().getDisplay(), "Sans", 16, 0x1000001);
        Font font2 = new Font(this.getTablature().getDisplay(), "Sans", 8, 0x1000001);
        Font font3 = new Font(this.getTablature().getDisplay(), "Sans", 8, 0x1000001);
        gC.setFont(font);
        gC.drawString(string, this.getCenter(gC, string), 0);
        gC.setFont(font2);
        gC.drawString(string3, this.getCenter(gC, string3), 30);
        gC.setFont(font3);
        gC.drawString(string2, this.getRight(gC, string2), 50);
        font.dispose();
        font2.dispose();
        font3.dispose();
        this.setDefaultStyle(gC);
    }

    private int getCenter(GC gC, String string) {
        int n = gC.stringExtent((String)string).x;
        return (this.getMaxWidth() - n) / 2;
    }

    private int getRight(GC gC, String string) {
        int n = gC.stringExtent((String)string).x;
        return this.getMaxWidth() - n;
    }

    public void paintSong(GC gC, Rectangle rectangle, int n, int n2) {
    }

    public void paintSong(GC gC, int n, int n2) {
        ArrayList<SongTrackCoords> arrayList = new ArrayList<SongTrackCoords>();
        arrayList.add(this.getTablature().getCaret().getSongCoords().getTrack(this.documentData.getTrackNumber()));
        this.paintTracks(arrayList, gC, null, n, n2);
    }

    public void paintTracks(List list, GC gC, Rectangle rectangle, int n, int n2) {
        int n3 = n2 + this.getDefaultFirstTrackSpan();
        int n4 = this.getDefaultFirstTrackSpan();
        int n5 = 0;
        SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(0);
        songTrackCoords.getLyricPainter().start(this.getSkippedBeats(songTrackCoords.getMeasuresCoords()));
        TrackSpacing trackSpacing = new TrackSpacing(this);
        TempLine tempLine = this.getTempLines(n, songTrackCoords.getMeasuresCoords(), this.documentData.getFromMeasure() - 1, trackSpacing);
        while (!tempLine.measures.isEmpty()) {
            trackSpacing.setSize(2, this.isScoreEnabled() ? 35 : 0);
            if (this.isScoreEnabled()) {
                trackSpacing.setSize(1, Math.abs(tempLine.minY));
                if (this.isScoreEnabled() && tempLine.maxY + 20 > 55) {
                    trackSpacing.setSize(3, tempLine.maxY - this.getScoreLineSpan() * 4);
                }
            }
            trackSpacing.setSize(11, this.isScoreEnabled() ? this.getMinScoreTabSpan() : this.getStringSpan());
            trackSpacing.setSize(12, this.isTablatureEnabled() ? (this.isScoreEnabled() ? songTrackCoords.getTabHeight() + this.getStringSpan() + 1 : songTrackCoords.getTabHeight() + this.getStringSpan() / 2 * 5 + 1) : 0);
            trackSpacing.setSize(13, 10);
            this.checkTopSpan(trackSpacing);
            n5 = trackSpacing.getSize();
            if (n3 + n5 + 8 > this.getMaxHeight()) {
                this.makePage(gC);
                n3 = this.getDefaultFirstTrackSpan();
            }
            this.paintLine(songTrackCoords, tempLine, gC, n, n3, trackSpacing, rectangle);
            n3 += n5 + 8;
            n4 += n5 + 8;
            trackSpacing = new TrackSpacing(this);
            tempLine = this.getTempLines(n, songTrackCoords.getMeasuresCoords(), tempLine.lastIndex + 1, trackSpacing);
        }
        this.makePage(gC);
        this.setHeight(n4);
    }

    public void paintLine(SongTrackCoords songTrackCoords, TempLine tempLine, GC gC, int n, int n2, TrackSpacing trackSpacing, Rectangle rectangle) {
        int n3;
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        if (tempLine.fullLine && (n3 = this.getMaxWidth() - tempLine.tempWith) != 0 && tempLine.measures.size() > 0) {
            n7 = n3 / tempLine.measures.size();
        }
        for (n3 = 0; n3 < tempLine.measures.size(); ++n3) {
            int n8 = (Integer)tempLine.measures.get(n3);
            MeasureCoords measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(n8);
            measureCoords.setPosX(n4);
            measureCoords.setPosY(n5);
            measureCoords.setTs(trackSpacing);
            songTrackCoords.getLyricPainter().setCurrentMeasure(measureCoords);
            measureCoords.setFirstOfLine(n3 == 0);
            this.paintMeasure(measureCoords, gC, n4, n5, n7, rectangle);
            songTrackCoords.getLyricPainter().paintCurrentNoteBeats(gC, this, measureCoords, n4, n5);
            if ((n4 += measureCoords.getWidth() + measureCoords.getSpan()) <= n6) continue;
            n6 = n4;
        }
        this.setWidth(n6 > this.getWidth() ? n6 : this.getWidth());
    }

    public TempLine getTempLines(int n, List list, int n2, TrackSpacing trackSpacing) {
        TempLine tempLine = new TempLine();
        this.divisionCount = 1;
        for (int i = n2; i < list.size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)list.get(i);
            if (measureCoords.getMeasure().getNumber() < this.documentData.getFromMeasure() || measureCoords.getMeasure().getNumber() > this.documentData.getToMeasure()) continue;
            if (tempLine.tempWith + measureCoords.getWidth() >= this.getMaxWidth() && !tempLine.measures.isEmpty()) {
                tempLine.fullLine = true;
                return tempLine;
            }
            tempLine.tempWith += measureCoords.getWidth();
            tempLine.maxY = measureCoords.getMaxY() > tempLine.maxY ? measureCoords.getMaxY() : tempLine.maxY;
            tempLine.minY = measureCoords.getMinY() < tempLine.minY ? measureCoords.getMinY() : tempLine.minY;
            tempLine.addMeasure(i);
            measureCoords.registerEffects(trackSpacing);
        }
        return tempLine;
    }

    public int getSkippedBeats(List list) {
        int n = 0;
        for (int i = 0; i < this.documentData.getFromMeasure() - 1; ++i) {
            MeasureCoords measureCoords = (MeasureCoords)list.get(i);
            n += measureCoords.getBeatPositions().size();
        }
        return n;
    }

    public int getSpanForQuarter(Duration duration) {
        double d = 1000.0 / (double)duration.getTime() * (double)this.getMinSpan(duration);
        return (int)d;
    }

    private int getMinSpan(Duration duration) {
        int n = 0;
        switch (duration.getValue()) {
            case 1: {
                n = 18;
                break;
            }
            case 2: {
                n = 16;
                break;
            }
            case 4: {
                n = 14;
                break;
            }
            case 8: {
                n = 12;
                break;
            }
            default: {
                n = 12;
            }
        }
        return n;
    }

    public boolean followMeasure(MeasureCoords measureCoords, boolean bl) {
        return false;
    }

    public boolean isCaretVisible() {
        return false;
    }

    public boolean isPlayModeEnabled() {
        return false;
    }

    public void setDefaultStyle(GC gC) {
        gC.setFont(this.getTablature().getPrinterDefaultFont());
    }

    public void setNoteStyle(GC gC) {
        gC.setFont(this.getTablature().getPrinterNoteFont());
    }

    public void setTimeSignatureStyle(GC gC) {
        gC.setFont(this.getTablature().getPrinterTimeSignatureFont());
    }

    public int getMaxWidth() {
        return this.document.getPageSize().width - 10;
    }

    public int getMaxHeight() {
        return this.document.getPageSize().height;
    }

    public boolean isFirstMeasure(Measure measure) {
        return measure.getNumber() == this.documentData.getFromMeasure();
    }

    public boolean isLastMeasure(Measure measure) {
        return measure.getNumber() == this.documentData.getToMeasure();
    }

    public int getStringSpan() {
        return 8;
    }

    public int getScoreLineSpan() {
        return 7;
    }

    public int getDefaultTrackSpan() {
        return 8;
    }

    public int getMinScoreTabSpan() {
        return 20;
    }

    public int getDefaultFirstTrackSpan() {
        return 8;
    }

    public int getDefaultEffectSpan() {
        return super.getDefaultEffectSpan();
    }

    private class TempLine {
        private int tempWith;
        private int lastIndex;
        private int startBeat;
        private boolean fullLine;
        private List measures = new ArrayList();
        private int maxY = 0;
        private int minY = 50;

        private TempLine() {
        }

        private void addMeasure(int n) {
            this.measures.add(new Integer(n));
            this.lastIndex = n;
        }
    }
}

