/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;

public class PageViewLayout
extends ViewLayout {
    private int displayWidth;
    private int divisionCount;

    public PageViewLayout(Tablature tablature, SongManager songManager, boolean bl, boolean bl2, boolean bl3) {
        super(tablature, songManager, bl, bl2, bl3);
        this.displayWidth = this.getTablature().getDisplay().getBounds().width - this.getTablature().getVerticalBar().getSize().x;
    }

    public int getMode() {
        return 1;
    }

    public void paintSong(GC gC, Rectangle rectangle, int n, int n2) {
        this.clearTrackPositions();
        if (this.isMultitrack()) {
            this.paintTracks(this.getTablature().getCaret().getSongCoords().getTrackCoords(), gC, rectangle, n, n2);
        } else {
            ArrayList<SongTrackCoords> arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
            this.paintTracks(arrayList, gC, rectangle, n, n2);
        }
        this.paintCaret(gC);
    }

    public void paintTracks(List list, GC gC, Rectangle rectangle, int n, int n2) {
        int n3 = n2 + this.getDefaultFirstTrackSpan();
        int n4 = this.getDefaultFirstTrackSpan();
        int n5 = 0;
        SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(0);
        int n6 = songTrackCoords.getMeasuresCoords().size();
        int n7 = 0;
        while (n6 > n7) {
            TempLine tempLine = null;
            for (int i = 0; i < list.size(); ++i) {
                SongTrackCoords songTrackCoords2 = (SongTrackCoords)list.get(i);
                TrackSpacing trackSpacing = new TrackSpacing(this);
                trackSpacing.setSize(2, this.isScoreEnabled() ? DEFAULT_SCORE_LINE_SPAN * 5 : 0);
                if (n7 == 0) {
                    songTrackCoords2.getLyricPainter().start();
                }
                tempLine = this.getTempLines(n, songTrackCoords2.getMeasuresCoords(), n7, trackSpacing);
                if (AUTO_SPACING_ENABLED && this.isScoreEnabled()) {
                    trackSpacing.setSize(1, Math.abs(tempLine.minY));
                    if (this.isScoreEnabled() && tempLine.maxY + MIN_SCORE_TAB_SPAN > DEFAULT_SCORE_SPAN) {
                        trackSpacing.setSize(3, tempLine.maxY - this.getScoreLineSpan() * 4);
                    }
                }
                trackSpacing.setSize(11, this.isScoreEnabled() ? this.getMinScoreTabSpan() : this.getStringSpan());
                trackSpacing.setSize(12, this.isTablatureEnabled() ? (this.isScoreEnabled() ? songTrackCoords2.getTabHeight() + this.getStringSpan() + 1 : songTrackCoords2.getTabHeight() + this.getStringSpan() / 2 * 5 + 1) : 0);
                trackSpacing.setSize(13, 10);
                this.checkTopSpan(trackSpacing);
                this.paintLine(songTrackCoords2, tempLine, gC, n, n3, trackSpacing, i, rectangle);
                n5 = trackSpacing.getSize();
                this.addTrackPosition(songTrackCoords2.getTrack().getNumber(), n3, n5);
                if (tempLine.lastIndex + 1 >= n6 && tempLine.tempWith < this.getMaxWidth() - 20) {
                    this.paintLines(songTrackCoords2, trackSpacing, gC, n + 20 + tempLine.tempWith + 2, n3, this.getMaxWidth() - 15 - (n + tempLine.tempWith));
                }
                n3 += n5 + DEFAULT_TRACK_SPAN;
                n4 += n5 + DEFAULT_TRACK_SPAN;
            }
            n7 = tempLine.lastIndex + 1;
        }
        this.setHeight(n4);
    }

    public void paintLine(SongTrackCoords songTrackCoords, TempLine tempLine, GC gC, int n, int n2, TrackSpacing trackSpacing, int n3, Rectangle rectangle) {
        int n4;
        int n5 = n + 20;
        int n6 = n2;
        int n7 = 0;
        boolean bl = false;
        boolean bl2 = n5 + n > rectangle.x - 1500 && n5 + n < rectangle.x + rectangle.width + 100;
        boolean bl3 = n6 + trackSpacing.getSize() > rectangle.y && n6 < rectangle.y + rectangle.height + 80;
        int n8 = 0;
        if (tempLine.fullLine && (n4 = this.getMaxWidth() - tempLine.tempWith) != 0 && tempLine.measures.size() > 0) {
            n8 = n4 / tempLine.measures.size();
        }
        for (n4 = 0; n4 < tempLine.measures.size(); ++n4) {
            int n9 = (Integer)tempLine.measures.get(n4);
            MeasureCoords measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(n9);
            measureCoords.setPosX(n5);
            measureCoords.setPosY(n6);
            measureCoords.setTs(trackSpacing);
            songTrackCoords.getLyricPainter().setCurrentMeasure(measureCoords);
            measureCoords.setFirstOfLine(n4 == 0);
            if (bl2 && bl3) {
                this.paintMeasure(measureCoords, gC, n5, n6, n8, rectangle);
                songTrackCoords.getLyricPainter().paintCurrentNoteBeats(gC, this, measureCoords, n5, n6);
            } else {
                measureCoords.setOutOfBounds(true);
            }
            if ((n5 += measureCoords.getWidth() + measureCoords.getSpan()) <= n7) continue;
            n7 = n5;
        }
        this.setWidth(n7 > this.getWidth() ? n7 : this.getWidth());
    }

    public TempLine getTempLines(int n, List list, int n2, TrackSpacing trackSpacing) {
        TempLine tempLine = new TempLine();
        this.divisionCount = 1;
        for (int i = n2; i < list.size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)list.get(i);
            if (tempLine.tempWith + measureCoords.getWidth() >= this.getMaxWidth() && !tempLine.measures.isEmpty()) {
                tempLine.fullLine = true;
                return tempLine;
            }
            tempLine.tempWith += measureCoords.getWidth();
            tempLine.maxY = measureCoords.getMaxY() > tempLine.maxY ? measureCoords.getMaxY() : tempLine.maxY;
            tempLine.minY = measureCoords.getMinY() < tempLine.minY ? measureCoords.getMinY() : tempLine.minY;
            tempLine.addMeasure(i);
            measureCoords.registerEffects(trackSpacing);
        }
        return tempLine;
    }

    public boolean followMeasure(MeasureCoords measureCoords, boolean bl) {
        return this.getTablature().moveScrollVerticalTo(measureCoords, this.getDefaultFirstTrackSpan(), bl);
    }

    public int getMaxWidth() {
        return this.displayWidth - 40;
    }

    private class TempLine {
        private int tempWith;
        private int lastIndex;
        private int startBeat;
        private boolean fullLine;
        private List measures = new ArrayList();
        private int maxY = 0;
        private int minY = 0;

        private TempLine() {
        }

        private void addMeasure(int n) {
            this.measures.add(new Integer(n));
            this.lastIndex = n;
        }
    }
}

