/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;

public class LinearViewLayout
extends ViewLayout {
    public LinearViewLayout(Tablature tablature, SongManager songManager, boolean bl, boolean bl2, boolean bl3) {
        super(tablature, songManager, bl, bl2, bl3);
    }

    public int getMode() {
        return 2;
    }

    public void paintSong(GC gC, Rectangle rectangle, int n, int n2) {
        this.clearTrackPositions();
        if (this.isMultitrack()) {
            this.paintTracks(this.getTablature().getCaret().getSongCoords().getTrackCoords(), gC, rectangle, n, n2);
        } else {
            ArrayList<SongTrackCoords> arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
            this.paintTracks(arrayList, gC, rectangle, n, n2);
        }
        this.paintCaret(gC);
    }

    public void paintTracks(List list, GC gC, Rectangle rectangle, int n, int n2) {
        int n3 = n2 + this.getDefaultFirstTrackSpan();
        int n4 = this.getDefaultFirstTrackSpan();
        for (int i = 0; i < list.size(); ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(i);
            TrackSpacing trackSpacing = new TrackSpacing(this);
            trackSpacing.setSize(2, this.isScoreEnabled() ? DEFAULT_SCORE_LINE_SPAN * 5 : 0);
            songTrackCoords.getLyricPainter().start();
            if (AUTO_SPACING_ENABLED) {
                int n5 = 0;
                int n6 = 0;
                for (int j = 0; j < songTrackCoords.getMeasuresCoords().size(); ++j) {
                    MeasureCoords measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(j);
                    n5 = measureCoords.getMaxY() > n5 ? measureCoords.getMaxY() : n5;
                    n6 = measureCoords.getMinY() < n6 ? measureCoords.getMinY() : n6;
                    measureCoords.registerEffects(trackSpacing);
                }
                trackSpacing.setSize(1, this.isScoreEnabled() ? Math.abs(n6) : 0);
                if (this.isScoreEnabled() && n5 + MIN_SCORE_TAB_SPAN > DEFAULT_SCORE_SPAN) {
                    trackSpacing.setSize(3, n5 - this.getScoreLineSpan() * 4);
                }
            }
            trackSpacing.setSize(11, this.isScoreEnabled() ? this.getMinScoreTabSpan() : this.getStringSpan());
            trackSpacing.setSize(12, this.isTablatureEnabled() ? (this.isScoreEnabled() ? songTrackCoords.getTabHeight() + this.getStringSpan() + 1 : songTrackCoords.getTabHeight() + this.getStringSpan() / 2 * 5 + 1) : 0);
            trackSpacing.setSize(13, 10);
            this.checkTopSpan(trackSpacing);
            this.paintMeasures(songTrackCoords, songTrackCoords.getMeasuresCoords(), gC, n, n3, trackSpacing, rectangle);
            this.paintLines(songTrackCoords, trackSpacing, gC, n + (this.getWidth() + 2), n3, rectangle.width - (n + this.getWidth()));
            int n7 = trackSpacing.getSize();
            this.addTrackPosition(songTrackCoords.getTrack().getNumber(), n3, n7);
            n3 += n7 + DEFAULT_TRACK_SPAN;
            n4 += n7 + DEFAULT_TRACK_SPAN;
        }
        this.setHeight(n4);
    }

    public void paintMeasures(SongTrackCoords songTrackCoords, List list, GC gC, int n, int n2, TrackSpacing trackSpacing, Rectangle rectangle) {
        int n3 = n + 20;
        int n4 = n2;
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            MeasureCoords measureCoords = (MeasureCoords)list.get(i);
            measureCoords.setPosX(n3);
            measureCoords.setPosY(n4);
            measureCoords.setTs(trackSpacing);
            songTrackCoords.getLyricPainter().setCurrentMeasure(measureCoords);
            boolean bl2 = n3 + measureCoords.getWidth() > rectangle.x - 100 && n3 < rectangle.x + rectangle.width + measureCoords.getWidth() + 100;
            boolean bl3 = bl = n4 + trackSpacing.getSize() > rectangle.y && n4 < rectangle.y + rectangle.height + 80;
            if (bl2 && bl) {
                this.paintMeasure(measureCoords, gC, n3, n4, 0, rectangle);
                songTrackCoords.getLyricPainter().paintCurrentNoteBeats(gC, this, measureCoords, n3, n4);
            } else {
                measureCoords.setOutOfBounds(true);
            }
            n3 += measureCoords.getWidth();
        }
        this.setWidth(n3 + -n);
    }

    public boolean followMeasure(MeasureCoords measureCoords, boolean bl) {
        return this.getTablature().moveScrollHorizontalTo(measureCoords, 20, bl);
    }
}

