/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.edit;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.edit.MouseKit;
import org.herac.tuxguitar.song.models.InstrumentString;

public class EditorKit
implements MouseListener,
MouseMoveListener,
MouseTrackListener {
    public static final int MOUSE_MODE_SELECTION = 1;
    public static final int MOUSE_MODE_EDITION = 2;
    private int mouseMode;
    private boolean natural;
    private Tablature tablature;
    private MouseKit mouseKit;

    public EditorKit(Tablature tablature) {
        this.tablature = tablature;
        this.mouseKit = new MouseKit(this);
        this.tablature.addMouseMoveListener(this);
        this.tablature.addMouseListener(this);
        this.tablature.addMouseTrackListener(this);
        this.setDefaults();
    }

    private void setDefaults() {
        this.setMouseMode(TuxGuitar.instance().getConfig().getIntConfigValue("editor.mouse.mode", 2));
        this.setNatural(TuxGuitar.instance().getConfig().getBooleanConfigValue("editor.natural.key.mode", true));
    }

    public int getMouseMode() {
        return this.mouseMode;
    }

    public void setMouseMode(int n) {
        this.mouseMode = n;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean bl) {
        this.natural = bl;
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public void tryBack() {
        this.mouseKit.tryBack();
    }

    public boolean select(int n, int n2) {
        MeasureCoords measureCoords;
        SongTrackCoords songTrackCoords;
        if (n >= 0 && n2 >= 0 && (songTrackCoords = this.getTrackCoords(n2)) != null && (measureCoords = this.getMeasureCoords(songTrackCoords, n, n2)) != null) {
            MeasureComponent measureComponent = this.getMeasureComponent(measureCoords, n);
            InstrumentString instrumentString = this.getMeasureString(measureCoords, n2);
            if (measureComponent != null) {
                int n3 = instrumentString != null ? instrumentString.getNumber() : this.getTablature().getCaret().getSelectedString().getNumber();
                this.getTablature().getCaret().moveTo(songTrackCoords, measureCoords, measureComponent, n3);
            }
            return true;
        }
        return false;
    }

    public SongTrackCoords getTrackCoords(int n) {
        return this.getTablature().getSongCoords().getTrackAt(n);
    }

    public MeasureCoords getMeasureCoords(SongTrackCoords songTrackCoords, int n, int n2) {
        return songTrackCoords.getMeasureAt(n, n2);
    }

    public MeasureComponent getMeasureComponent(MeasureCoords measureCoords, int n) {
        return measureCoords.getComponentAt(n);
    }

    public InstrumentString getMeasureString(MeasureCoords measureCoords, int n) {
        return measureCoords.getStringAt(n);
    }

    public void mouseDown(MouseEvent mouseEvent) {
        this.select(mouseEvent.x, mouseEvent.y);
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (this.select(mouseEvent.x, mouseEvent.y)) {
            TuxGuitar.instance().redraw();
            TuxGuitar.instance().updateCache(true);
            if (!TuxGuitar.instance().getPlayer().isRunning() && this.getTablature().getViewLayout().isScoreEnabled() && this.getMouseMode() == 2) {
                this.mouseKit.mouseUp(mouseEvent);
            }
        }
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (!TuxGuitar.instance().getPlayer().isRunning() && this.getTablature().getViewLayout().isScoreEnabled() && this.getMouseMode() == 2) {
            this.mouseKit.mouseMove(mouseEvent);
        }
    }

    public void mouseExit(MouseEvent mouseEvent) {
        if (!TuxGuitar.instance().getPlayer().isRunning() && this.getTablature().getViewLayout().isScoreEnabled() && this.getMouseMode() == 2) {
            this.mouseKit.mouseExit(mouseEvent);
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseEnter(MouseEvent mouseEvent) {
    }

    public void mouseHover(MouseEvent mouseEvent) {
    }
}

